﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Result.h>

#include <nn/audio/audio_Result.h>
#include <nn/audio/audio_DeviceTypes.h>

#include "audio_AudioDeviceImplStub.h"

namespace nn { namespace audio { namespace server { namespace detail {

void InitializeAudioDevice(const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT
{
    NN_UNUSED(id);
}

void FinalizeAudioDevice(const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT
{
    NN_UNUSED(id);
}

int ListAudioDeviceName(AudioDeviceName* outDeviceNames, int count, common::RevisionInfo revisionInfo) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(outDeviceNames);
    NN_SDK_ASSERT(count >= 0);
    NN_UNUSED(outDeviceNames);
    NN_UNUSED(count);
    NN_UNUSED(revisionInfo);
    return 0;
}

void SetAudioDeviceOutputVolume(const AudioDeviceName* outDeviceNames, float count, const nn::applet::AppletResourceUserId& id, common::RevisionInfo revisionInfo) NN_NOEXCEPT
{
    NN_UNUSED(outDeviceNames);
    NN_UNUSED(count);
    NN_UNUSED(id);
    NN_UNUSED(revisionInfo);
}

float GetAudioDeviceOutputVolume(const AudioDeviceName* outDeviceNames, const nn::applet::AppletResourceUserId& id, common::RevisionInfo revisionInfo) NN_NOEXCEPT
{
    NN_UNUSED(outDeviceNames);
    NN_UNUSED(id);
    NN_UNUSED(revisionInfo);
    return 1.f;
}

void GetActiveAudioDeviceName(AudioDeviceName* outDeviceName, common::RevisionInfo revisionInfo) NN_NOEXCEPT
{
    NN_UNUSED(outDeviceName);
    NN_UNUSED(revisionInfo);
}

Result QueryAudioDeviceSystemEvent(nn::os::NativeHandle* outHandle, const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT
{
    NN_UNUSED(outHandle);
    NN_UNUSED(id);
    return ResultNotImplemented();
}

Result QueryAudioDeviceInputNotificationEvent(nn::os::NativeHandle* outHandle, const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT
{
    NN_UNUSED(outHandle);
    NN_UNUSED(id);
    return ResultNotImplemented();
}

Result QueryAudioDeviceOutputNotificationEvent(nn::os::NativeHandle* outHandle, const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT
{
    NN_UNUSED(outHandle);
    NN_UNUSED(id);
    return ResultNotImplemented();
}

int GetActiveChannelCount() NN_NOEXCEPT
{
    return 0;
}

float GetAudioSystemMasterVolumeSetting(const AudioDeviceName* name) NN_NOEXCEPT
{
    NN_UNUSED(name);
    return 0.0f;
}

}}}} // namespace nn::audio::server::detail
