﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/applet/applet_Types.h>
#include <nn/os/os_NativeHandle.h>

#include "../../common/audio_UpdateDataHeader.h"

#pragma warning( push )
#pragma warning ( disable : 4668 )
#include <mmdeviceapi.h>
#include <audioclient.h>
#pragma warning( pop )

namespace nn { namespace audio { namespace server { namespace detail {

void InitializeAudioDevice(const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT;
void FinalizeAudioDevice(const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT;
int ListAudioDeviceName(AudioDeviceName* outDeviceNames, int count, common::RevisionInfo revisionInfo) NN_NOEXCEPT;
void SetAudioDeviceOutputVolume(const AudioDeviceName* outDeviceName, float volume, const nn::applet::AppletResourceUserId& id, common::RevisionInfo revisionInfo) NN_NOEXCEPT;
float GetAudioDeviceOutputVolume(const AudioDeviceName* outDeviceNames, const nn::applet::AppletResourceUserId& id, common::RevisionInfo revisionInfo) NN_NOEXCEPT;
void GetActiveAudioDeviceName(AudioDeviceName* outDeviceName, common::RevisionInfo revisionInfo) NN_NOEXCEPT;
Result QueryAudioDeviceSystemEvent(nn::os::NativeHandle* outHandle, const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT;
Result QueryAudioDeviceInputNotificationEvent(nn::os::NativeHandle* outHandle, const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT;
Result QueryAudioDeviceOutputNotificationEvent(nn::os::NativeHandle* outHandle, const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT;
int GetActiveChannelCount() NN_NOEXCEPT;
float GetAudioSystemMasterVolumeSetting(const AudioDeviceName* name) NN_NOEXCEPT;

}}}}  // namespace nn::audio::server::detail

