﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_StaticAssert.h>
#include <nn/audio/audio_VoiceTypes.h>
#include "../audio_AddrTypes.h"
#include "../dsp/audio_BiquadFilterEffect.h"
#include "../common/audio_BuildDefinition.h"

namespace nn {
namespace audio {

struct VoiceState
{
    int64_t playedSampleCount;

    int32_t offset;
    int32_t waveBufferIndex;

    bool isWaveBufferValid[VoiceType::WaveBufferCountMax];
    int32_t waveBufferConsumed;

    // sample rate converter
    static const int SampleHistoryCount = 4;
    int32_t sampleHistory[SampleHistoryCount];
    int32_t fraction;

    DspAddr externalContext;
    static const size_t ContextSize = 16;
    int8_t context[ContextSize];

    BiquadFilterState biquadFilterState[VoiceType::BiquadFilterCountMax];
    int32_t lastSamples[MixBufferCountMax];

    uint32_t externalContextSize;
    bool isExternalContextInitialized;
    int8_t _padding0[3];

#if NN_AUDIO_DSP_ADDR_SIZE != 8
    // On Win(64 bit) environment, sizeof(DspAddr) is 8 byte.
    int8_t _padding1[4];
#endif

    int8_t _padding2[48];
};

NN_STATIC_ASSERT(sizeof(VoiceState) % BufferAlignSize == 0);

}  // namespace audio
}  // namespace nn
