﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/audio/server/audio_UserServiceHipcServer.h>
#include <nn/os/os_Event.h>

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>

#include "audio_AudioRendererManagerImpl.h"
#include "../shim/audio_CreateAudioRendererManager.h"
#include "../shim/audio_CreateAudioOutManager.h"
#include "../shim/audio_CreateAudioInManager.h"
#include "../shim/audio_CreateFinalOutputRecorderManager.h"
#include "../shim/audio_ServiceName.h"
#include "audio_AudioHipcServerManager.h"

namespace nn { namespace audio { namespace server {

namespace {
const int SessionCountMax = 30;
const int PortCountMax = 4;

struct ServerManagerOption
{
    static const size_t PointerTransferBufferSize = UserHipcTransferBufferSize;
};

class MyServerManager : public AudioHipcServerManager<SessionCountMax, PortCountMax, ServerManagerOption>
{
};

std::aligned_storage<sizeof(MyServerManager), NN_ALIGNOF(MyServerManager)>::type g_MyServerManagerStorage;
MyServerManager* g_pMyServerManager;

}  // namespace anonymous

void InitializeUserServiceServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pMyServerManager == nullptr);

    g_pMyServerManager = new (&g_MyServerManagerStorage) MyServerManager;

    auto sessionCountMax = 30;
    g_pMyServerManager->RegisterObjectForPort(CreateAudioRendererManagerByDfc(), sessionCountMax, AudioRendererServiceForUserName);
    g_pMyServerManager->RegisterObjectForPort(CreateAudioOutManagerByDfc(), sessionCountMax, AudioOutServiceForUserName);
    g_pMyServerManager->RegisterObjectForPort(CreateAudioInManagerByDfc(), sessionCountMax, AudioInServiceForUserName);
    g_pMyServerManager->RegisterObjectForPort(CreateFinalOutputRecorderManagerByDfc(), sessionCountMax, FinalOutputRecorderServiceName);

    g_pMyServerManager->Start();
}

void LoopUserServiceServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(g_pMyServerManager);
    g_pMyServerManager->LoopAuto();
}

void SleepUserServiceServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(g_pMyServerManager);
    g_pMyServerManager->Sleep();
}

void WakeUserServiceServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(g_pMyServerManager);
    g_pMyServerManager->Wake();
}

void RequestStopUserServiceServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(g_pMyServerManager);
    g_pMyServerManager->RequestStop();
}

void FinalizeUserServiceServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(g_pMyServerManager);
    g_pMyServerManager->~MyServerManager();
    g_pMyServerManager = nullptr;
}

}}}  // namespace nn::audio::server
