﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../common/audio_BehaviorParameters.h"

namespace nn { namespace audio { namespace server {

enum class PerformanceMetricsDataFormat
{
    Invalid,
    Version1,
    Version2,
};

class BehaviorInfo
{
    friend class InfoUpdater;

public:
    BehaviorInfo() NN_NOEXCEPT;
    common::RevisionInfo GetProcessRevision() const NN_NOEXCEPT;
    common::RevisionInfo GetUserLibRevision() const NN_NOEXCEPT;
    void AppendError(common::BehaviorParameter::ErrorInfo& errorInfo) NN_NOEXCEPT;
    void SetUserLibRevision(common::RevisionInfo revision) NN_NOEXCEPT;
    bool IsMemoryPoolForceMappingEnabled() const NN_NOEXCEPT;
    bool IsAdpcmLoopContextBugFixed() const NN_NOEXCEPT;
    bool IsSplitterSupported() const NN_NOEXCEPT;
    bool IsLongSizePreDelaySupported() const NN_NOEXCEPT;
    bool IsAudioRenererProcessingTimeLimit70PercentSupported() const NN_NOEXCEPT;
    bool IsAudioRenererProcessingTimeLimit75PercentSupported() const NN_NOEXCEPT;
    bool IsAudioRenererProcessingTimeLimit80PercentSupported() const NN_NOEXCEPT;
    bool IsCommandProcessingTimeEstimatorVersion2Supported() const NN_NOEXCEPT;
    bool IsVariadicCommandBufferSizeSupported() const NN_NOEXCEPT;
    bool IsFlushVoiceWaveBuffersSupported() const NN_NOEXCEPT;
    bool IsElapsedFrameCountSupported() const NN_NOEXCEPT;
    bool IsPerformanceMetricsDataFormatVersion2Supported() const NN_NOEXCEPT;
    PerformanceMetricsDataFormat GetPerformanceMetricsDataFormat() const NN_NOEXCEPT;
    bool IsSplitterBugFixed() const NN_NOEXCEPT;
    bool IsVoicePlayedSampleCountResetAtLoopPointSupported() const NN_NOEXCEPT;
    bool IsAudioCodecSupported() const NN_NOEXCEPT;
    bool IsVoicePitchAndSrcSkippedSupported() const NN_NOEXCEPT;

private:
    // for InfoUpdater() only.
    void ClearError() NN_NOEXCEPT;
    void UpdateFlags(const common::BehaviorParameter::Flags& flag) NN_NOEXCEPT;
    void CopyErrorInfo(common::BehaviorParameter::ErrorInfo* pDest, int* errorInfoCount) const NN_NOEXCEPT;


    common::RevisionInfo m_ProcessRevision;
    common::RevisionInfo m_UserLibRevision;

    common::BehaviorParameter::Flags m_Flags;
    common::BehaviorParameter::ErrorInfo m_ErrorInfo[common::BehaviorParameter::ErrorInfoCountMax];
    int32_t m_ErrorCount;
};

}}}  // namespace nn::audio::server::
