﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/dd/dd_Types.h>
#include "../audio_VoiceInfoManager.h"
#include "../audio_EffectManager.h"
#include "../audio_MixManager.h"
#include "../audio_SinkManager.h"
#include "../audio_PerformanceBufferManager.h"
#include "../audio_BehaviorManager.h"

#include "audio_VoiceState.h"
#include "audio_ServiceBehaviorInfo.h"
#include "audio_ServiceEffectInfo.h"
#include "audio_ServiceVoiceInfo.h"
#include "audio_ServiceMemoryPoolInfo.h"
#include "audio_ServiceMixInfo.h"
#include "audio_ServiceSinkInfo.h"
#include "audio_ServiceSplitterInfo.h"
#include "audio_PerformanceMetricsManager.h"

#include "../common/audio_BehaviorParameters.h"
#include "../common/audio_SplitterParameters.h"

namespace nn { namespace audio { namespace server {

class InfoUpdater
{
protected:
    uintptr_t m_InParameter;
    uintptr_t m_InParameterOrigin;
    size_t m_InParameterSize;
    common::UpdateDataHeader* m_InParameterHeader;
    common::UpdateDataHeader* m_OutStatusHeader;

    uintptr_t m_OutStatus;
    uintptr_t m_OutStatusOrigin;
    size_t m_OutStatusSize;

    BehaviorInfo& m_BehaviorInfo;

    nn::dd::ProcessHandle m_ClientProcessHandle;
public:
    InfoUpdater(uintptr_t inParameter, size_t inParameterSize, uintptr_t outStatus, size_t outStatusSize, nn::dd::ProcessHandle clientProcessHandle, BehaviorInfo& behaviorInfo) NN_NOEXCEPT;

    Result UpdateVoices(VoiceContext& voiceContext, server::MemoryPoolInfo* pPoolInfos, int memoryPoolCount, DspAddr opusBuffer) NN_NOEXCEPT;
    Result UpdateVoiceChannelResources(VoiceContext& voiceContext) NN_NOEXCEPT;
    Result UpdateEffects(EffectContext& context, bool isRenderererActive, server::MemoryPoolInfo* pPoolInfos, int memoryPoolCount) NN_NOEXCEPT;
    Result UpdateMixes(MixContext& mixContext, int mixBufferCount, const EffectContext& effectContext, const SplitterContext& splitterContext) NN_NOEXCEPT;
    Result UpdateSinks(SinkContext& sinkContext, server::MemoryPoolInfo* pPoolInfos, int memoryPoolCount) NN_NOEXCEPT;
    Result UpdateMemoryPools(server::MemoryPoolInfo* pOutInfos, int memoryPoolCount) NN_NOEXCEPT;
    Result UpdatePerformanceBuffer(void* performance, size_t performanceSize, PerformanceManager* manager) NN_NOEXCEPT;
    Result UpdateBehaviorInfo(BehaviorInfo* pBehaviorInfo) NN_NOEXCEPT;
    Result UpdateSplitterInfo(SplitterContext& sendContext) NN_NOEXCEPT;
    Result UpdateErrorInfo(BehaviorInfo* pBehaviorInfo) NN_NOEXCEPT;
    Result UpdateRendererInfo(int64_t elapsedFrameCount) NN_NOEXCEPT;
    Result CheckConsumedSize() NN_NOEXCEPT;
};

}}}  // namespace nn::audio::server
