﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../common/audio_Command.h"
#include "audio_PerformanceMetricsManager.h"
#include "audio_ServiceVoiceInfo.h"
#include "audio_ServiceMemoryPoolInfo.h"
#include "audio_ServiceMixInfo.h"
#include "audio_ServiceSinkInfo.h"

namespace nn { namespace audio { namespace server {

class ICommandBuffer
{
public :
    virtual PcmInt16DataSourceCommand* GeneratePcmInt16DataSourceCommand(const server::VoiceInfo* pVoice, VoiceState* state, int mixBufferCount, int32_t channel, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual AdpcmDataSourceCommand* GenerateAdpcmDataSourceCommand(const server::VoiceInfo* pVoice, VoiceState* state, int mixBufferCount, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual OpusDataSourceCommand* GenerateOpusDataSourceCommand(const server::VoiceInfo* pVoice, VoiceState* state, int mixBufferCount, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual AuxCommand* GenerateAuxCommand(int mixBufferOffset, int8_t input, int8_t output, const AuxBufferAddresses* pAddresses, bool enabled, int32_t sampleCount, DspAddr sendBuffer, DspAddr returnBuffer, int updateCount, int offset, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual DelayCommand* GenerateDelayEffectCommand(int mixBufferOffset, const DelayParameter* pParameter, void* pState, bool enabled, DspAddr workBuffer, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual ReverbCommand* GenerateReverbEffectCommand(int mixBufferOffset, const ReverbParameter* pParameter, void* pState, bool enabled, bool longSizePreDelaySupported, DspAddr workBuffer, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual I3dl2ReverbCommand* GenerateI3dl2ReverbEffectCommand(int mixBufferOffset, const I3dl2ReverbParameter* pParameter, void* pState, bool enabled, DspAddr workBuffer, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual CopyMixBufferCommand* GenerateCopyMixBufferCommand(int inputBufferIndex, int outputBufferIndex, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual BiquadFilterCommand* GenerateBiquadFilterCommand(int mixBufferOffset, const BiquadFilterParameter* pFilterParameter, BiquadFilterState* pState, int8_t input, int8_t output, bool needInitialization, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual MixCommand* GenerateMixCommand(int inputBufferIndex, int outputBufferIndex, float mixVolume, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual MixRampCommand* GenerateMixRampCommand(int inputBufferIndex, int outputBufferIndex, float mixVolume0, float mixVolume1, DspAddr voiceStateDspAddr, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual MixRampGroupedCommand* GenerateMixRampGroupedCommand(int mixBufferCount, int inputBufferIndex, int outputBufferIndexStart, const float* pMixVolume, const float* pMixVolumePrev, DspAddr lastSampleAddress, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual DepopPrepareCommand* GenerateDepopPrepareCommand(VoiceState* state, int32_t* depopBuffer, int mixBufferCount, int mixBufferOffset, NodeId nodeId, bool commandEnabled) NN_NOEXCEPT = 0;
    virtual DepopForMixBuffersCommand* GenerateDepopForMixBuffersCommand(int32_t* depopBuffer, int mixBufferOffset, int mixBufferCount, NodeId nodeId, int32_t sampleRate) NN_NOEXCEPT = 0;
    virtual ClearMixBufferCommand* GenerateClearMixBufferCommand(NodeId nodeId) NN_NOEXCEPT = 0;
    virtual VolumeCommand* GenerateVolumeCommand(float volume, int mixBufferCount, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual VolumeRampCommand* GenerateVolumeRampCommand(float volume0, float volume1, int mixBufferCount, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual DeviceSinkCommand* GenerateDeviceSinkCommand(int mixBufferOffset, const server::SinkInfoBase* pSinkInfo, uint32_t sessionId, DspAddr mixBufferAddr, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual CircularBufferSinkCommand* GenerateCircularBufferSinkCommand(int mixBufferOffset, const server::SinkInfoBase* pSinkInfo, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual DownMix6chTo2chCommand* GenerateDownMixCommand(int mixBufferOffset, const int8_t* input, const int8_t* output, const int32_t* downMixParam, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual UpsampleCommand* GenerateUpsampleCommand(int mixBufferOffset, UpsamplerInfo* pInfo, int inputCount, const int8_t* input, int32_t buffeCount, int32_t sampleCount, int32_t sampleRate, NodeId nodeId) NN_NOEXCEPT = 0;
    virtual PerformanceCommand* GeneratePerformanceCommand(const PerformanceEntryAddresses* entry, const PerformanceCommandType type, NodeId nodeId) NN_NOEXCEPT = 0;
};

}}}  // namespace nn::audio::server
