﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "audio_ICommandProcessingTimeEstimator.h"

namespace nn { namespace audio { namespace server {

class CommandProcessingTimeEstimatorVersion2 : public ICommandProcessingTimeEstimator
{
protected:
    int m_SampleCount;
    int m_MixBufferCount;
public:
    void Initialize(int sampleCount, int mixBufferCount) NN_NOEXCEPT;
    uint32_t Estimate(const PcmInt16DataSourceCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const AdpcmDataSourceCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const OpusDataSourceCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const VolumeCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const VolumeRampCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const BiquadFilterCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const MixCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const MixRampCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const MixRampGroupedCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const DepopPrepareCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const DepopForMixBuffersCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const DelayCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const UpsampleCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const DownMix6chTo2chCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const AuxCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const DeviceSinkCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const CircularBufferSinkCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const ReverbCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const I3dl2ReverbCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const PerformanceCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const ClearMixBufferCommand& command) NN_NOEXCEPT;
    uint32_t Estimate(const CopyMixBufferCommand& command) NN_NOEXCEPT;
};

}}}  // namespace nn::audio::server
