﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/audio/detail/audio_Log.h>
#include <nn/audio/server/audio_FirmwareDebugSettings.h>
#include "audio_AudioOutManagerForDebuggerImpl.h"
#include "audio_AppletVolumeManager.h"

namespace nn { namespace audio { namespace server {

nn::Result AudioOutManagerForDebuggerImpl::RequestSuspend(const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT
{
    NN_DETAIL_AUDIO_TRACE("[audio][AudioOut] RequestSuspendForDebugger id.lower(%llu)\n", id.lower);

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    // TODO: Workaround for SIGLO-34523
    if(IsSuspendForDebuggerEnabled() == false)
    {
        NN_RESULT_SUCCESS;
    }
#endif

    return AppletVolumeManager::SuspendForDebugger(AppletVolumeManager::SessionType_AudioOut, id);
}

nn::Result AudioOutManagerForDebuggerImpl::RequestResume(const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT
{
    NN_DETAIL_AUDIO_TRACE("[audio][AudioOut] RequestResumeForDebugger id.lower(%llu)\n", id.lower);

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    // TODO: Workaround for SIGLO-34523
    if(IsSuspendForDebuggerEnabled() == false)
    {
        NN_RESULT_SUCCESS;
    }
#endif

    return AppletVolumeManager::ResumeForDebugger(AppletVolumeManager::SessionType_AudioOut, id);
}

}}}  // namespace nn::audio::server
