﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>

namespace nn { namespace audio { namespace dsp {

void ApplyUniformGain(int32_t* output, const int32_t* input, int32_t gain, int sampleCount) NN_NOEXCEPT;
void ApplyUniformGain1(int32_t* output, const int32_t* input, int32_t gain, int sampleCount) NN_NOEXCEPT;
void ApplyUniformGain2(int32_t* output, const int32_t* input, int32_t gain, int sampleCount) NN_NOEXCEPT;
void ApplyUniformGain4(int32_t* output, const int32_t* input, int32_t gain, int sampleCount) NN_NOEXCEPT;
void ApplyUniformGain(float* output, const float* input, float gain, int sampleCount) NN_NOEXCEPT;
void ApplyUniformGain1(float* output, const float* input, float gain, int sampleCount) NN_NOEXCEPT;
void ApplyUniformGain4(float* output, const float* input, float gain, int sampleCount) NN_NOEXCEPT;
void ApplyLinearEnvelopeGain(int32_t* output, const int32_t* input, int32_t gain, int32_t delta, int sampleCount) NN_NOEXCEPT;
void ApplyLinearEnvelopeGain1(int32_t* output, const int32_t* input, int32_t gain, int32_t delta, int sampleCount) NN_NOEXCEPT;
void ApplyLinearEnvelopeGain2(int32_t* output, const int32_t* input, int32_t gain, int32_t delta, int sampleCount) NN_NOEXCEPT;
void ApplyLinearEnvelopeGain4(int32_t* output, const int32_t* input, int32_t gain, int32_t delta, int sampleCount) NN_NOEXCEPT;
void ApplyLinearEnvelopeGain(float* output, const float* input, float gain, float delta, int sampleCount) NN_NOEXCEPT;
void ApplyLinearEnvelopeGain1(float* output, const float* input, float gain, float delta, int sampleCount) NN_NOEXCEPT;
void ApplyLinearEnvelopeGain4(float* output, const float* input, float gain, float delta, int sampleCount) NN_NOEXCEPT;

}}}  // namespace nn::audio::dsp
