﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "../common/audio_BuildDefinition.h"

#if defined(NN_AUDIO_ENABLE_ADSP_RENDERER)
#include "audio_MailBoxImplByAdspMailBoxCpu.h"
#elif defined(_NX_AUDIO_DSP_)
#include "audio_MailBoxImplByAdspMailBoxAdsp.h"
#elif defined(NN_AUDIO_ENABLE_CPU_RENDERER)
#include "audio_MailBoxImplByMessageQueue.h"
#else
#error Unsupported platform.
#endif

namespace nn { namespace audio { namespace dsp {

class MailBox
{
protected:
    MailBoxImpl m_Impl;
public:
    static void Initialize() NN_NOEXCEPT;
    static void Finalize() NN_NOEXCEPT;
    void Open(int id, bool isServer) NN_NOEXCEPT;
    void Close() NN_NOEXCEPT;
    void Send(int32_t message) NN_NOEXCEPT;
    int32_t Recv() NN_NOEXCEPT;
};

}}}  // namespace nn::audio::dsp

