﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "audio_EffectReverb.h"

namespace nn { namespace audio {

// delay lengths for FDN, in msec
static const qf FdnDelayLen[ReverbParameter::LateMode_Count][ReverbParameter::FeedbackDelayNetworkCount] =
{
    { QF_CONST(53.9533f), QF_CONST(79.1926f), QF_CONST(116.2388f), QF_CONST(130.6153f) }, // rooms
    { QF_CONST(53.9533f), QF_CONST(79.1926f), QF_CONST(116.2388f), QF_CONST(170.6153f) }, // hall
    { QF_CONST(5.0f),     QF_CONST(10.0f),    QF_CONST(5.0f),      QF_CONST(10.0f)     }, // metal corridor
    { QF_CONST(47.03f),   QF_CONST(71.0f),    QF_CONST(103.0f),    QF_CONST(170.0f)    }, // cavernous
    { QF_CONST(53.9533f), QF_CONST(79.1926f), QF_CONST(116.2388f), QF_CONST(170.6153f) }  // MAX
};

// delay lengths for FDN, in msec
static const qf AllPassDelayLen[ReverbParameter::LateMode_Count][ReverbParameter::FeedbackDelayNetworkCount] =
{
    { QF_CONST(7.0f), QF_CONST(9.0f), QF_CONST(13.0f), QF_CONST(17.0f) },  // rooms
    { QF_CONST(7.0f), QF_CONST(9.0f), QF_CONST(13.0f), QF_CONST(17.0f) },  // hall
    { QF_CONST(1.0f), QF_CONST(1.0f), QF_CONST(1.0f),  QF_CONST(1.0f)  },  // metal corridor
    { QF_CONST(7.0f), QF_CONST(7.0f), QF_CONST(13.0f), QF_CONST(9.0f)  },  // cavernous
    { QF_CONST(7.0f), QF_CONST(9.0f), QF_CONST(13.0f), QF_CONST(17.0f) }   // MAX
};

// delay lengths in msec for early reflection taps.  last tap is the feed to the late reverb
static const qf ErTaps[ReverbParameter::EarlyMode_Count][ReverbParameter::EarlyReflectionCount + 1] =
{
    //L,               L,               R,               R,               C,               C,               Lr,              Lr,              Rr,              Rr,              to_late
    { QF_CONST(0.0f),  QF_CONST(3.5f),  QF_CONST(2.8f),  QF_CONST(3.9f),  QF_CONST(2.7f),  QF_CONST(13.4f), QF_CONST(7.9f),  QF_CONST(8.4f),  QF_CONST(9.9f),  QF_CONST(12.0f), QF_CONST(12.5f) }, // small room
    { QF_CONST(0.0f),  QF_CONST(11.8f), QF_CONST(5.5f),  QF_CONST(11.2f), QF_CONST(10.4f), QF_CONST(38.1f), QF_CONST(22.2f), QF_CONST(29.6f), QF_CONST(21.2f), QF_CONST(24.8f), QF_CONST(40.0f) }, // large room
    { QF_CONST(0.0f),  QF_CONST(41.5f), QF_CONST(20.5f), QF_CONST(41.3f), QF_CONST(0.0f),  QF_CONST(29.5f), QF_CONST(33.8f), QF_CONST(45.2f), QF_CONST(46.8f), QF_CONST(0.0f),  QF_CONST(50.0f) }, // hall
    { QF_CONST(33.1f), QF_CONST(43.3f), QF_CONST(22.8f), QF_CONST(37.9f), QF_CONST(14.9f), QF_CONST(35.3f), QF_CONST(17.9f), QF_CONST(34.2f), QF_CONST(0.0f),  QF_CONST(43.3f), QF_CONST(50.0f) }, // cavern
    { QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f)  }  // no early reflections
};

static const qf ErCoefs2[ReverbParameter::EarlyMode_Count][ReverbParameter::EarlyReflectionCount] =
{
    //L,               L,               R,               R,               C,               C,               Lr,              Lr,              Rr,              Rr
    { QF_CONST(0.7f),  QF_CONST(0.68f), QF_CONST(0.7f),  QF_CONST(0.68f), QF_CONST(0.7f),  QF_CONST(0.68f), QF_CONST(0.7f),  QF_CONST(0.68f), QF_CONST(0.68f), QF_CONST(0.68f) },  // small room
    { QF_CONST(0.7f),  QF_CONST(0.68f), QF_CONST(0.7f),  QF_CONST(0.68f), QF_CONST(0.7f),  QF_CONST(0.68f), QF_CONST(0.68f), QF_CONST(0.68f), QF_CONST(0.68f), QF_CONST(0.68f) },  // large room
    { QF_CONST(0.5f),  QF_CONST(0.7f),  QF_CONST(0.7f),  QF_CONST(0.68f), QF_CONST(0.5f),  QF_CONST(0.68f), QF_CONST(0.68f), QF_CONST(0.7f),  QF_CONST(0.68f), QF_CONST(0.0f)  },  // hall
    { QF_CONST(0.93f), QF_CONST(0.92f), QF_CONST(0.87f), QF_CONST(0.86f), QF_CONST(0.94f), QF_CONST(0.81f), QF_CONST(0.8f),  QF_CONST(0.77f), QF_CONST(0.76f), QF_CONST(0.65f) },  // cavern
    { QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f),  QF_CONST(0.0f)  }   // no early reflections
};

}} // namespace nn::audio
