﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio/audio_Common.h> // NN_AUDIO_ALIGNAS_BUFFER_ALIGN
#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include "audio_Qf.h"
#include "audio_EffectCommon.h"
#include "audio_DelayLine.h"

namespace nn { namespace audio {

struct DelayParameter
{
    static const int SupportedChannelCountMax = 6;
    static const int ChannelCountMax = 6;

    int8_t _input[ChannelCountMax];   // 入力ミックスバッファインデックス
    int8_t _output[ChannelCountMax];  // 出力ミックスバッファインデックス
    uint16_t _numChannelCountMax;
    uint16_t _numChannels;

    int32_t _delayTimeMax;            // [MilliSeconds]
    int32_t _delayTime;               // [MilliSeconds]
    qf      _sampleRate;              // QF [Hz]
    qf      _inGain;                  // QF
    qf      _feedbackGain;            // QF
    qf      _outGain;                 // QF
    qf      _dryGain;                 // QF
    qf      _channelSpread;           // QF
    qf      _lowPassAmount;           // QF

    EffectParameterStatus _parameterStatus;
    int8_t _padding[3];
};
NN_STATIC_ASSERT(sizeof(DelayParameter) == 56);

struct NN_AUDIO_ALIGNAS_BUFFER_ALIGN DelayState
{
    int32_t dummy[5]; // Work around to force cache separation
    qf _inGain;
    qf _outGain;
    qf _dryGain;
    FXDelayLine _delayLines[DelayParameter::ChannelCountMax];
    qf _feedback;
    qf _feedbackDirect;
    qf _feedbackCross;
    qf _lowPassFilterCoefficientB0;
    qf _lowPassFilterCoefficientA1;
    qf _pLowPassFilterHistory[DelayParameter::ChannelCountMax];
};

inline bool IsSupportedDelayChannelCount(int channel) NN_NOEXCEPT
{
    return (channel == 1) ||
           (channel == 2) ||
           (channel == 4) ||
           (channel == 6);
}

void InitializeDelayEffect(const DelayParameter* pParameter, DelayState* state, void* workBuffer);
void SetDelayEffectParameter(const DelayParameter *pParameter, DelayState* state);
void ApplyDelayEffect(const DelayParameter* pParameter, DelayState* state, bool enabled, const int32_t** ppInData, int32_t** ppOutData, int sampleCount);

}}// namespace nn::audio
