﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <array>
#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace audio { namespace dsp {

class DspExceptionNotifier
{
    NN_DISALLOW_COPY( DspExceptionNotifier );
    NN_DISALLOW_MOVE( DspExceptionNotifier );
public:
    typedef void (*Observer)(void*);
private:
    struct ObserverHolder
    {
        Observer observer;
        void* args;
    };

    static const int ObserversCountMax = 4;
    std::array<ObserverHolder, ObserversCountMax> m_ObserverHolders;
    nn::os::Mutex m_Mutex;
    DspExceptionNotifier() NN_NOEXCEPT;
    ~DspExceptionNotifier() NN_NOEXCEPT;
    bool AddObserverImpl(Observer observer, void* pArgs) NN_NOEXCEPT;
    bool RemoveObserverImpl(Observer observer) NN_NOEXCEPT;
    void NotifyImpl() NN_NOEXCEPT;
    static DspExceptionNotifier& GetInstance() NN_NOEXCEPT;
public:
    static bool AddObserver(Observer observer, void* pArgs = nullptr) NN_NOEXCEPT;
    static bool RemoveObserver(Observer observer) NN_NOEXCEPT;
    static void Notify() NN_NOEXCEPT;
};

}}} // namespace nn::audio::dsp

