﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "audio_Cache.h"
#include "../common/audio_BuildDefinition.h"

#ifdef _NX_AUDIO_DSP_
#include <os/arch/cache.h>
#elif defined(NN_AUDIO_SYSTEM_PROCESS)
#include <nn/dd/dd_Cache.h>
#include <nn/dd/dd_MemoryBarrier.h>
#elif defined(NN_AUDIO_ENABLE_CPU_RENDERER) || defined(NN_BUILD_CONFIG_OS_WIN)
// pass
#else
#error "Not supportted Target specified."
#endif

// Maybe these definitions should be placed in each own files.
namespace nn { namespace audio { namespace dsp {

#if defined(_NX_AUDIO_DSP_)

void FlushDataCache(const void* addr, size_t size) NN_NOEXCEPT
{
    _NN_AUDIO_FLUSH_BUFFER(addr, size);
    cache_flush_range(reinterpret_cast<addr_t>(addr), size);
}

void InvalidateDataCache(void* addr, size_t size) NN_NOEXCEPT
{
    _NN_AUDIO_INVAL_BUFFER(addr, size);
    cache_inv_range(reinterpret_cast<addr_t>(addr), size);
}

#elif defined(NN_AUDIO_SYSTEM_PROCESS) && !defined(NN_BUILD_CONFIG_OS_WIN)

void FlushDataCache(const void* addr, size_t size) NN_NOEXCEPT
{
    dd::FlushDataCache(addr, size);
}

void InvalidateDataCache(void* addr, size_t size) NN_NOEXCEPT
{
    dd::InvalidateDataCache(addr, size);
}

#else

void FlushDataCache(const void* addr, size_t size) NN_NOEXCEPT
{
    NN_UNUSED(addr);
    NN_UNUSED(size);
}

void InvalidateDataCache(void* addr, size_t size) NN_NOEXCEPT
{
    NN_UNUSED(addr);
    NN_UNUSED(size);
}

#endif

}}} // namespace nn::audio::dsp

