﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include "audio_EffectCommon.h" // EffectParameterStatus

namespace nn { namespace audio {

struct BiquadFilterState
{
    int64_t context[2];
};

struct BiquadFilterEffectParameter
{
    static const int ChannelCountMax = 6;

    int8_t _input[ChannelCountMax];
    int8_t _output[ChannelCountMax];
    int16_t _numerator[3];
    int16_t _denominator[2];
    int8_t _channelCount;
    EffectParameterStatus _parameterStatus;
};
NN_STATIC_ASSERT(sizeof(BiquadFilterEffectParameter) == 24);

struct NN_AUDIO_ALIGNAS_BUFFER_ALIGN BiquadFilterEffectState
{
    nn::audio::BiquadFilterState filterStates[6];
};

}} // nn::audio
