﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdint>
#include "audio_BiquadFilter.h"

#if defined(__ARM_NEON__) || defined(__ARM_NEON)
#include "detail/audio_BiquadFilter.neon.h"
#else  // defined(__ARM_NEON__) || defined(__ARM_NEON)
#include "detail/audio_BiquadFilter.generic.h"
#endif  // defined(__ARM_NEON__) || defined(__ARM_NEON)

namespace nn { namespace audio { namespace dsp {

void ApplyBiquadFilter(int32_t* output, const int32_t* input, const int16_t* numerator, const int16_t* denominator, BiquadFilterState* state, int sampleCount) NN_NOEXCEPT
{
    detail::ApplyBiquadFilter(output, input, numerator, denominator, state->context, sampleCount);
}

}}}  // namespace nn::audio::dsp
