﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "audio_Util.h"

namespace nn { namespace audio { namespace common {

class WorkBufferAllocator
{
    NN_DISALLOW_COPY(WorkBufferAllocator);
    NN_DISALLOW_MOVE(WorkBufferAllocator);

private:
    const uintptr_t m_Buffer;
    const size_t m_Size;
    size_t m_Offset;
private:
    WorkBufferAllocator();
public:
    WorkBufferAllocator(void* buffer, size_t size) NN_NOEXCEPT;
    void* Allocate(size_t size, size_t align = InfoTypeFieldAlignSize) NN_NOEXCEPT;
    size_t GetSize() const NN_NOEXCEPT
    {
        return m_Size;
    };

    size_t GetUsedSize() const NN_NOEXCEPT
    {
        return m_Offset;
    };

    size_t GetFreeSize() const NN_NOEXCEPT
    {
        return m_Size - m_Offset;
    };
};

}}}  // nn::namespace audio
