﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_BitArray.h>
#include <nn/util/util_BytePtr.h>
#include <nn/util/util_PlacementArray.h>

namespace nn { namespace audio { namespace common {

class EdgeMatrix : private nn::util::BitArray
{
    NN_DISALLOW_COPY(EdgeMatrix);

    int m_NodeCount;

public:
    static size_t GetWorkBufferSize(int nodeCount) NN_NOEXCEPT;

    EdgeMatrix() NN_NOEXCEPT;
    void Initialize(void* workMemroy, size_t workMemorySize, int nodeCount) NN_NOEXCEPT;
    int GetNodeCount() const NN_NOEXCEPT;

    bool Connected(int src, int dst) const NN_NOEXCEPT;
    void Connect(int src, int dst) NN_NOEXCEPT;
    void Disconnect(int src, int dst) NN_NOEXCEPT;
    void RemoveEdges(int src) NN_NOEXCEPT;
};

class NodeStates
{
public:
    enum class SearchState
    {
        Initial,
        Discovered,
        Finished,
    };

    class Stack : private nn::util::PlacementArray<int>
    {
        int index;
        int countMax;

    public:
        Stack() NN_NOEXCEPT;
        static size_t CalcBufferSize(int count) NN_NOEXCEPT;
        void Reset(int* buffer, size_t bufferSize, int count) NN_NOEXCEPT;
        int Count() const NN_NOEXCEPT;
        void push(int val) NN_NOEXCEPT;
        int top() const NN_NOEXCEPT;
        int pop() NN_NOEXCEPT;
    };

private:
    int m_Count;
    int m_SortPosition;
    nn::util::BitArray m_Discovered;
    nn::util::BitArray m_Finished;
    nn::util::PlacementArray<int> m_SortedIndex;
    Stack m_WorkStack;

    static bool DepthFirstSearch(NodeStates& states, EdgeMatrix& edges, NodeStates::Stack& workStack) NN_NOEXCEPT;
    SearchState GetState(int index) const NN_NOEXCEPT;
    void SetState(int index, SearchState state) NN_NOEXCEPT;
    void ResetState() NN_NOEXCEPT;
    void PushTsortResult(int index) NN_NOEXCEPT;

public:
    static size_t GetWorkBufferSize(int nodeCount) NN_NOEXCEPT;

    NodeStates() NN_NOEXCEPT;
    void Initialize(void* buffer, size_t bufferSize, int nodeCount) NN_NOEXCEPT;
    int GetNodeCount() const NN_NOEXCEPT;
    bool Tsort(EdgeMatrix& edges);

    std::reverse_iterator<const int *> ResultBegin() const NN_NOEXCEPT;
    std::reverse_iterator<const int *> ResultEnd() const NN_NOEXCEPT;
};

}}}  // namespace nn::audio::common
