﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "audio_NodeIdManager.h"

namespace nn { namespace audio { namespace common {

NN_DEFINE_STATIC_CONSTANT( const int NodeIdManager::TypeMax );
NN_DEFINE_STATIC_CONSTANT( const int NodeIdManager::BaseMax );
NN_DEFINE_STATIC_CONSTANT( const int NodeIdManager::VariationMax );

NodeId NodeIdManager::GetNodeId(NodeIdType type, int base, int variation) NN_NOEXCEPT
{
    NN_SDK_ASSERT(type == NodeIdType::Voice || type == NodeIdType::Mix || type == NodeIdType::Sink);
    NN_SDK_ASSERT_MINMAX(base, 0, BaseMax);
    NN_SDK_ASSERT_MINMAX(variation, 0, VariationMax);

    return (static_cast<uint32_t>(type) << TypeShift) |
           (base << BaseShift) |
           (variation << VariationShift);
}

NodeIdManager::NodeIdType NodeIdManager::GetType(NodeId nodeId) NN_NOEXCEPT
{
    const auto mask = (1 << TypeWidth) - 1;
    return static_cast<NodeIdType>((nodeId >> TypeShift) & mask);
}

int NodeIdManager::GetBase(NodeId nodeId) NN_NOEXCEPT
{
    const auto mask = (1 << BaseWidth) - 1;
    return static_cast<int>((nodeId >> BaseShift) & mask);
}

int NodeIdManager::GetVariation(NodeId nodeId) NN_NOEXCEPT
{
    const auto mask = (1 << VariationWidth) - 1;
    return static_cast<int>((nodeId >> VariationShift) & mask);
}

NodeId NodeIdManager::GetInvalidNodeId() NN_NOEXCEPT
{
    return (static_cast<uint32_t>(NodeIdType::Invalid) << TypeShift);
}

}}} // namespace nn::audio::common
