﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstddef>
#include <cstdint>
#include <nn/audio/audio_Adpcm.h>
#include "../audio_AddrTypes.h"

namespace nn { namespace audio { namespace common {

struct WaveBuffer
{
    DspAddr buffer;
    uint32_t size;
    int32_t startSampleOffset;
    int32_t endSampleOffset;
    bool loop;
    bool isEndOfStream;

    DspAddr pContext;
    uint32_t contextSize;
};

NN_FORCEINLINE
size_t CalcBufferSizeOfPcmInt16(int sampleCount) NN_NOEXCEPT
{
    return sampleCount * sizeof(int16_t);
}

NN_FORCEINLINE
size_t CalcBufferSizeOfAdpcm(int sampleCount) NN_NOEXCEPT
{
    auto frames = sampleCount / AdpcmFrameSampleCount;
    auto samplesLeft = sampleCount % AdpcmFrameSampleCount;
    auto additionalBytes = 0;

    if (samplesLeft)
    {
        additionalBytes += 1;               // 1 byte frame header
        additionalBytes += samplesLeft / 2; // number of even bytes
        if (samplesLeft % 2)                // 1 nibble left
        {
            additionalBytes++;
        }
    }

    return (frames * AdpcmFrameSize) + additionalBytes;
}

}}} // namespace nn::audio::common
