﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <type_traits>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/util/util_BitPack.h>
#include <nn/util/util_BitFlagSet.h>
#include <nn/util/util_BytePtr.h>

#include "audio_UpdateDataHeader.h"
#include "audio_Util.h"

namespace nn { namespace audio { namespace common { namespace BehaviorParameter {

const int FlagsBitLength = 64;

enum FlagIndex
{
    FlagIndex_MemoryPoolAssert = 0,
};

typedef nn::util::BitFlagSet<FlagsBitLength> Flags;

struct ErrorInfo
{
    nn::Result _result;
    int8_t _padding[4];
    uint64_t   _info;

    bool IsError() NN_NOEXCEPT
    {
        return _result.IsFailure();
    }
    void SetResult(nn::Result result, uint64_t info) NN_NOEXCEPT
    {
        _result = result;
        _info = info;
    };
};

NN_STATIC_ASSERT(sizeof(ErrorInfo) == 16);

struct NN_AUDIO_INFOTYPE_FILED_ALIGN InParameter
{
    nn::audio::common::RevisionInfo _revision;
    int8_t _padding[4];
    Flags _parameter;
};
NN_AUDIO_INFOTYPE_CHECK(InParameter, 16);

const int ErrorInfoCountMax = 10;
struct NN_AUDIO_INFOTYPE_FILED_ALIGN OutStatus
{
    ErrorInfo _infos[ErrorInfoCountMax];
    int32_t _infoCount;
    int8_t _padding[12];
};
NN_AUDIO_INFOTYPE_CHECK(OutStatus, 176);

}}}}  // namespace nn::audio::common::BehaviorParameter
