﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio/audio_AudioRendererTypes.h>
#include <nn/audio/audio_PerformanceMetricsTypes.h>
#include <nn/os/os_Mutex.h>
#include <nn/util/util_BytePtr.h>
#include "common/audio_Util.h"

// for Client side library header

namespace nn {
namespace audio {

namespace PerformanceBufferInfo {

struct NN_AUDIO_INFOTYPE_FILED_ALIGN InParameter
{
    NodeId detailTarget;
    int8_t _padding[12];
};
NN_AUDIO_INFOTYPE_CHECK(InParameter, 16);

struct NN_AUDIO_INFOTYPE_FILED_ALIGN OutStatus
{
    uint32_t consumedSize;
    int8_t _padding[12];
};
NN_AUDIO_INFOTYPE_CHECK(InParameter, 16);

} // namespace PerformaceBufferInfo

class PerformanceBufferManager
{
public:
    PerformanceBufferManager() NN_NOEXCEPT;

    // User Access
    void* GetCurrentPerformanceFrameBuffer() NN_NOEXCEPT;
    void SetPerformanceFrameBuffer(void* buffer, size_t bufferSize) NN_NOEXCEPT;
    void SetDetailTarget(NodeId id) NN_NOEXCEPT;

    void* GetBufferBase() NN_NOEXCEPT;
    size_t GetBufferSize() NN_NOEXCEPT;
    size_t UpdateInParameter(void* pInParameter) NN_NOEXCEPT;
    size_t UpdateOutStatus(const void* pOutStatus) NN_NOEXCEPT;

private:
    nn::util::BytePtr m_BufferBase;
    size_t m_BufferSize;
    nn::os::Mutex m_Mutex;
    size_t m_ConsumedSize;
    NodeId m_DetailTarget;
};

}  // namespace audio
}  // namespace nn
