﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <limits>

#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/audio/audio_SubMixTypes.h>
#include <nn/audio/audio_FinalMixTypes.h>
#include "common/audio_SplitterParameters.h"
#include "common/audio_Util.h"

namespace nn {
namespace audio {

typedef int32_t MixId;

const MixId Invalid_MixId = std::numeric_limits<int32_t>::max();

// InParameter of Mix
struct NN_AUDIO_INFOTYPE_FILED_ALIGN MixInfo
{
    // SubMix/FinalMix 共通で使用する変数
    float volume;
    int32_t sampleRate;
    int32_t bufferCount;
    bool isInUse;
    int8_t _reserved1[3];

    MixId mixId;
    int32_t applyingEffectCount;
    NodeId nodeId;
    int8_t _reserved2[8];

    // SubMix でのみ使用される変数
    float mixVolume[MixBufferCountMax][MixBufferCountMax];
    MixId destinationMixId;
    common::SplitterInfoId splitterInfoId;

    static const MixId FinalMixId = 0;
    static const MixId SubMixIdFirst = FinalMixId + 1;
};
NN_STATIC_ASSERT(sizeof(MixInfo) % 16 == 0);


class MixManager
{
private:
    MixInfo* m_MixInfos;
    int32_t m_MixInfosCount;
    const int32_t m_MixBufferCount;
    const int32_t m_MixBufferSampleCount;
    int32_t m_UsedMixBufferCount;
    nn::os::Mutex m_Mutex;
public:
    MixManager(MixInfo* mixInfos, int mixInfoCount, int finalMixSampleRate, int mixBufferCount, int mixBufferSampleCount) NN_NOEXCEPT;
    bool Acquire(FinalMixType* pFinalMix, int bufferCount) NN_NOEXCEPT;
    void Release(FinalMixType* pFinalMix) NN_NOEXCEPT;
    int GetFinalMixSampleRate() const NN_NOEXCEPT;
    int GetMixBufferSampleCount() const NN_NOEXCEPT;

    bool Acquire(SubMixType* pSubMix, int bufferCount) NN_NOEXCEPT;
    void Release(SubMixType* pSubMix) NN_NOEXCEPT;

    bool IsValidMix(const SubMixType* pSubMix) const NN_NOEXCEPT;
    bool IsValidMix(const FinalMixType* pFinalMix) const NN_NOEXCEPT;

    size_t UpdateMixInParameter(void* pInParameter) NN_NOEXCEPT;
};

}  // namespace audio
}  // namespace nn
