﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio/audio_EffectTypes.h>
#include "dsp/audio_EffectReverb.h"

namespace nn { namespace audio {

inline ReverbParameter::EarlyMode ConvertToDspType(ReverbType::EarlyMode mode)
{
    switch(mode)
    {
    case ReverbType::EarlyMode_SmallRoom:
        return ReverbParameter::EarlyMode_SmallRoom;
    case ReverbType::EarlyMode_LargeRoom:
        return ReverbParameter::EarlyMode_LargeRoom;
    case ReverbType::EarlyMode_Hall:
        return ReverbParameter::EarlyMode_Hall;
    case ReverbType::EarlyMode_Cavern:
        return ReverbParameter::EarlyMode_Cavern;
    case ReverbType::EarlyMode_NoEarlyReflection:
        return ReverbParameter::EarlyMode_NoEarlyReflection;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

inline ReverbType::EarlyMode ConvertFromDspType(ReverbParameter::EarlyMode mode)
{
    switch(mode)
    {
    case ReverbParameter::EarlyMode_SmallRoom:
        return ReverbType::EarlyMode_SmallRoom;
    case ReverbParameter::EarlyMode_LargeRoom:
        return ReverbType::EarlyMode_LargeRoom;
    case ReverbParameter::EarlyMode_Hall:
        return ReverbType::EarlyMode_Hall;
    case ReverbParameter::EarlyMode_Cavern:
        return ReverbType::EarlyMode_Cavern;
    case ReverbParameter::EarlyMode_NoEarlyReflection:
        return ReverbType::EarlyMode_NoEarlyReflection;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

inline ReverbParameter::LateMode ConvertToDspType(ReverbType::LateMode mode)
{
    switch(mode)
    {
    case ReverbType::LateMode_Room:
        return ReverbParameter::LateMode_Room;
    case ReverbType::LateMode_Hall:
        return ReverbParameter::LateMode_Hall;
    case ReverbType::LateMode_MetalCorridor:
        return ReverbParameter::LateMode_MetalCorridor;
    case ReverbType::LateMode_Cavern:
        return ReverbParameter::LateMode_Cavern;
    case ReverbType::LateMode_MaximumDelay:
        return ReverbParameter::LateMode_MaximumDelay;
    case ReverbType::LateMode_Count:
        return ReverbParameter::LateMode_Count;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

inline ReverbType::LateMode ConvertFromDspType(ReverbParameter::LateMode mode)
{
    switch(mode)
    {
    case ReverbParameter::LateMode_Room:
        return ReverbType::LateMode_Room;
    case ReverbParameter::LateMode_Hall:
        return ReverbType::LateMode_Hall;
    case ReverbParameter::LateMode_MetalCorridor:
        return ReverbType::LateMode_MetalCorridor;
    case ReverbParameter::LateMode_Cavern:
        return ReverbType::LateMode_Cavern;
    case ReverbParameter::LateMode_MaximumDelay:
        return ReverbType::LateMode_MaximumDelay;
    case ReverbParameter::LateMode_Count:
        return ReverbType::LateMode_Count;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

}} // namespace nn::audio
