﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio/audio_Common.h>
#include <nn/audio/audio_AudioRendererTypes.h> // MixBufferCount
#include "dsp/audio_EffectCommon.h"
#include "dsp/audio_EffectDelay.h"
#include "dsp/audio_EffectReverb.h"
#include "dsp/audio_EffectI3dl2Reverb.h"
#include "dsp/audio_BiquadFilterEffect.h"
#include "audio_AddrTypes.h"
#include "common/audio_Util.h"

namespace nn {
namespace audio {

struct BufferMixerParameter
{
    int8_t _input[MixBufferCountMax];   // 入力ミックスバッファインデックス
    int8_t _output[MixBufferCountMax];  // 出力ミックスバッファインデックス
    float _volume[MixBufferCountMax];   // ボリューム
    int _channelCountMax;
};
NN_STATIC_ASSERT(sizeof(BufferMixerParameter) == 148);

/**
 * @brief AuxType を利用するのに必要な各種パラメータ
 */
struct AuxParameter
{
    int8_t  _input[MixBufferCountMax];   // 入力ミックスバッファインデックス
    int8_t  _output[MixBufferCountMax];  // 出力ミックスバッファインデックス
    int32_t _channelCountMax;            // 入出力するミックスバッファ数
    int32_t _sampleRate;                 // AuxBuffer に格納されるサンプルのサンプルレート
    int32_t _sampleCount;                // AuxBuffer に格納されるサンプルのフレームサンプル数
    int32_t _mixBufferCount;             // 追加された SubMix / FinalMix が保持するミックスバッファの数

    uint64_t _sendAuxBufferInfo;         // renderer からのデータが格納される (ユーザーへの入力)
    uint64_t _sendBufferBase;
    uint64_t _returnAuxBufferInfo;       // renderer へのデータを格納する (ユーザーからの出力)
    uint64_t _returnBufferBase;

    // Added SDK 5.x.x -
    // these fields are referenced only in user lib.
    int32_t _frameBlockCountMax;
    int32_t _availableSampleCountMax;
    int32_t _mixBufferSampleCount;
    uint8_t _padding[4];
};
NN_STATIC_ASSERT(sizeof(AuxParameter) == 112);

struct AuxBufferAddresses
{
    DspAddr _sendDspInfo;
    DspAddr _sendBufferBase;
    DspAddr _returnDspInfo;
    DspAddr _returnBufferBase;
};

}; // namespace nn
}; // namespace audio
