﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>

#include "common/audio_BehaviorParameters.h"

// for Client side library header

namespace nn {
namespace audio {

class BehaviorManager
{
public:
    explicit BehaviorManager(uint32_t revision) NN_NOEXCEPT;

    size_t UpdateInParameter(void* pInParameter) const NN_NOEXCEPT;
    size_t UpdateOutStatus(const void* pOutStatus) NN_NOEXCEPT;

    void SetMemroyPoolForceMappingEnabled(bool enabled) NN_NOEXCEPT;
    bool GetMemroyPoolErrorAssertEnabled() const NN_NOEXCEPT;
    nn::Result CheckErrors() NN_NOEXCEPT;
    common::RevisionInfo GetRevision() const NN_NOEXCEPT;

private:
    mutable nn::os::Mutex m_Mutex;
    common::RevisionInfo m_Revision;
    common::BehaviorParameter::Flags m_Parameter;
    common::BehaviorParameter::ErrorInfo m_ErrorInfo[common::BehaviorParameter::ErrorInfoCountMax];
};

}  // namespace audio
}  // namespace nn

