﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio/audio_Common.h>
#include "audio_AddrTypes.h"

namespace nn {
namespace audio {

struct NN_AUDIO_ALIGNAS_BUFFER_ALIGN AuxInfoCpu
{
    uint32_t _readOffsetCount;
    uint32_t _writeOffsetCount;
    uint32_t _unpushedCount;
};

struct NN_AUDIO_ALIGNAS_BUFFER_ALIGN AuxInfoDsp
{
    uint32_t _readOffsetCount;
    uint32_t _writeOffsetCount;
    uint32_t _unpushedCount;
};

struct NN_AUDIO_ALIGNAS_BUFFER_ALIGN AuxBufferInfo
{
    NN_AUDIO_ALIGNAS_BUFFER_ALIGN AuxInfoCpu _cpu;
    NN_AUDIO_ALIGNAS_BUFFER_ALIGN AuxInfoDsp _dsp;
};

}  // namespace audio
}  // namespace nn
