﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/applet/applet_Storage.h>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <utility>
#include <nn/am/am_Result.h>
#include <nn/am/am_Shim.h>
#include <nn/sf/sf_Types.h>

namespace nn { namespace applet {

namespace detail {

inline am::service::IStorage* GetPointer(StorageHandle handle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(handle != InvalidStorageHandle, "specified StorageHandle is invalid");
    return static_cast<am::service::IStorage*>(handle._p);
}

inline StorageHandle MakeStorageHandle(sf::SharedPointer<am::service::IStorage> p) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(p);
    return {p.Detach()};
}

inline sf::SharedPointer<am::service::IStorage> GetShared(StorageHandle handle) NN_NOEXCEPT
{
    return sf::SharedPointer<am::service::IStorage>(GetPointer(handle), true);
}

template <typename Pop>
inline Result PopStorageImpl(bool* pRet, StorageHandle* pOut, Pop&& pop) NN_NOEXCEPT
{
    sf::SharedPointer<am::service::IStorage> ret;
    NN_RESULT_TRY(pop(&ret))
        NN_RESULT_CATCH(am::ResultNoStorage)
        {
            *pRet = false;
            NN_RESULT_SUCCESS;
        }
    NN_RESULT_END_TRY
    pOut->_p = ret.Detach();
    *pRet = true;
    NN_RESULT_SUCCESS;
}

template <typename Pop>
inline bool PopStorage(StorageHandle* pOut, Pop&& pop) NN_NOEXCEPT
{
    bool ret;
    NN_ABORT_UNLESS_RESULT_SUCCESS(PopStorageImpl(&ret, pOut, std::forward<Pop>(pop)));
    return ret;
}

}

}}
