﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_IntrusiveList.h>

#include <nn/apm/apm_ManagerImpl.h>
#include <nn/apm/server/apm.h>

namespace nn { namespace apm { namespace server {

// ISession 基底クラス。
// ManagerImpl 以外の共通部分は実装として持つ。
class Session :
    public nn::util::IntrusiveListBaseNode<Session>
{
public:
    explicit Session() NN_NOEXCEPT
    : m_ConfigurationNormal(PerformanceConfiguration_Invalid),
      m_ConfigurationBoost(PerformanceConfiguration_Invalid)
    {
        ;
    }
    virtual ~Session() NN_NOEXCEPT
    {
        ;
    }

    virtual PerformanceConfiguration GetPerformanceConfiguration(nn::apm::PerformanceMode performanceMode) NN_NOEXCEPT;

    virtual nn::Result SetPerformanceConfiguration(nn::apm::PerformanceMode performanceMode, nn::apm::PerformanceConfiguration performanceConfiguration) NN_NOEXCEPT = 0;
    virtual nn::Result GetPerformanceConfiguration(nn::sf::Out<nn::apm::PerformanceConfiguration> pOutPerformanceConfiguration, nn::apm::PerformanceMode performanceMode) NN_NOEXCEPT;

protected:
    nn::Result SetPerformanceConfigurationInternal(nn::apm::PerformanceMode performanceMode, nn::apm::PerformanceConfiguration performanceConfiguration) NN_NOEXCEPT;

private:
    PerformanceConfiguration m_ConfigurationNormal;
    PerformanceConfiguration m_ConfigurationBoost;
};

// ISession 実装クラス。
class SessionImpl :
    public Session
{
public:
    explicit SessionImpl(ManagerImpl* pParent) NN_NOEXCEPT;
    ~SessionImpl() NN_NOEXCEPT;

    virtual nn::Result SetPerformanceConfiguration(nn::apm::PerformanceMode performanceMode, nn::apm::PerformanceConfiguration performanceConfiguration) NN_NOEXCEPT NN_OVERRIDE;

private:
    nn::sf::SharedPointer<ManagerImpl> m_Parent;
};

// ISession 実装クラス。
class SessionPrivilegedImpl :
    public Session
{
public:
    explicit SessionPrivilegedImpl(ManagerPrivilegedImpl* pParent) NN_NOEXCEPT;
    ~SessionPrivilegedImpl() NN_NOEXCEPT;

    virtual nn::Result SetPerformanceConfiguration(nn::apm::PerformanceMode performanceMode, nn::apm::PerformanceConfiguration performanceConfiguration) NN_NOEXCEPT NN_OVERRIDE;

private:
    nn::sf::SharedPointer<ManagerPrivilegedImpl> m_Parent;
};

}}} // namespace nn::apm::server
