﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/apm/apm.h>
#include <nn/apm/apm_ISession.sfdl.h> // for ISession
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_Types.h> // for nn::sf::SharedPointer

namespace nn { namespace apm {

class SessionDataContainer
{
public:
    SessionDataContainer() NN_NOEXCEPT
    : m_ConfigurationBoost(PerformanceConfiguration_Invalid),
      m_ConfigurationNormal(PerformanceConfiguration_Invalid)
    {
    }

    void Backup(nn::sf::SharedPointer<nn::apm::ISession>& session) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(session->GetPerformanceConfiguration(&m_ConfigurationBoost, PerformanceMode_Boost));
        NN_ABORT_UNLESS_RESULT_SUCCESS(session->GetPerformanceConfiguration(&m_ConfigurationNormal, PerformanceMode_Normal));
    }

    void Restore(nn::sf::SharedPointer<nn::apm::ISession>& session) NN_NOEXCEPT
    {
        if ( m_ConfigurationBoost != PerformanceConfiguration_Invalid )
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(session->SetPerformanceConfiguration(PerformanceMode_Boost, m_ConfigurationBoost));
        }

        if ( m_ConfigurationNormal != PerformanceConfiguration_Invalid )
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(session->SetPerformanceConfiguration(PerformanceMode_Normal, m_ConfigurationNormal));
        }
    }

private:
    PerformanceConfiguration m_ConfigurationBoost;
    PerformanceConfiguration m_ConfigurationNormal;
};

}} // namespace nn::apm
