﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/apm/apm.h>

#include "apm_PerformanceList.h"

namespace nn { namespace apm {

struct PerformanceEntry
{
    PerformanceConfiguration performanceConfiguration;
    PerformanceType performanceTypeOnNormalMode;
    PerformanceType performanceTypeOnBoostMode;
};

const PerformanceEntry PerformanceList[] =
{
    { PerformanceConfiguration_Cpu1020MhzGpu384Mhz,           PerformanceType_Public,       PerformanceType_Public },
    { PerformanceConfiguration_Cpu1020MhzGpu768Mhz,           PerformanceType_NotSupported, PerformanceType_Public },
    { PerformanceConfiguration_Cpu1224MhzGpu691Mhz,           PerformanceType_NotSupported, PerformanceType_NotSupported },
    { PerformanceConfiguration_Cpu1020MhzGpu230Mhz,           PerformanceType_NotSupported, PerformanceType_NotSupported },
    { PerformanceConfiguration_Cpu1020MhzGpu307Mhz,           PerformanceType_Public,       PerformanceType_Public },
    { PerformanceConfiguration_Cpu1224MhzGpu230Mhz,           PerformanceType_NotSupported, PerformanceType_NotSupported },
    { PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1331Mhz, PerformanceType_Public,       PerformanceType_Public },
    { PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1331Mhz, PerformanceType_Public,       PerformanceType_Public },
    { PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1065Mhz, PerformanceType_NotSupported, PerformanceType_NotSupported },
    { PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1065Mhz, PerformanceType_NotSupported, PerformanceType_NotSupported },
    { PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1600Mhz, PerformanceType_Public,       PerformanceType_Public },
    { PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331Mhz, PerformanceType_Public,       PerformanceType_Public },
};

PerformanceType CheckPerformanceList(PerformanceMode mode, PerformanceConfiguration config) NN_NOEXCEPT
{
    PerformanceType type = PerformanceType_NotSupported;

    for ( const PerformanceEntry& entry : PerformanceList )
    {
        if ( entry.performanceConfiguration == config )
        {
            switch ( mode )
            {
            case PerformanceMode_Normal:
                type = entry.performanceTypeOnNormalMode;
                break;
            case PerformanceMode_Boost:
                type = entry.performanceTypeOnBoostMode;
                break;
            default:
                return PerformanceType_NotSupported;
            }

            break;
        }
    }

    return type;
}

}} // namespace nn::apm
