﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/nn_Common.h>
#include <nn/aocsrv/aocsrv_AddOnContentHipcServer.h>
#include <nn/aocsrv/detail/aocsrv_AddOnContentManagerImpl.h>
#include <nn/aocsrv/detail/aocsrv_AddOnContentServiceName.h>
#include <nn/os/os_Thread.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>

#include <type_traits>
#include <new>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace aocsrv {
    namespace {
        const int MaxListupCount = 2048; // とりあえず上限 2048 とのこと

        struct Service
        {
            nn::ns::ApplicationContentMetaStatus listupBuffer[MaxListupCount];   // 16 * MaxListupCount バイトあるので、このクラスをスタックにおいてはいけない。
            nn::sf::UnmanagedServiceObject<nn::aocsrv::detail::IAddOnContentManager, nn::aocsrv::detail::AddOnContentManagerImpl> serviceObject;
            Service() : serviceObject(listupBuffer, MaxListupCount) {}
        };

        class ServerManager : public nn::sf::HipcSimpleAllInOneServerManager<2, 1>
        {
        };


        std::aligned_storage<sizeof(ServerManager), NN_ALIGNOF(ServerManager)>::type g_ServerManagerStorage;
        ServerManager* g_pServerManager;

        Service g_Service;
    }

    void CreateServer() NN_NOEXCEPT
    {
        NN_SDK_ASSERT(!g_pServerManager);

        g_pServerManager = new (&g_ServerManagerStorage) ServerManager;

        auto sessionCountMax = 2;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_pServerManager->RegisterObjectForPort(
            g_Service.serviceObject.GetShared(), sessionCountMax, nn::aocsrv::detail::AocServiceName));
    }

    void StartServer() NN_NOEXCEPT
    {
        // INFO: 実機の ns で動かす場合は Start 不要
#if defined(NN_BUILD_CONFIG_OS_WIN)
        g_pServerManager->Start();
#endif
    }

    void LoopAuto() NN_NOEXCEPT
    {
        g_pServerManager->LoopAuto();
    }

    void RequestStopServer() NN_NOEXCEPT
    {
        g_pServerManager->RequestStop();
    }

    void DestroyServer() NN_NOEXCEPT
    {
        g_pServerManager->~ServerManager();
        g_pServerManager = nullptr;
    }
}} // namespace nn::aocsrv
