﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.am.service
{
    [CppRefPath(Location.FunctionsSfdlPath)]
    public interface ISelfController : IServiceObject
    {
        [MethodId(0)]
        Result Exit();

        [MethodId(1)]
        Result LockExit();

        [MethodId(2)]
        Result UnlockExit();

        /// <summary>
        /// ライブラリアプレット終了時に FATAL する区間の管理
        /// </summary>
        /// <remarks>
        /// 本 API は内部でネストカウンタを管理している。
        /// </remarks>
        [MethodId(3)]
        Result EnterFatalSection();

        [MethodId(4)]
        Result LeaveFatalSection();

        /// <summary>
        /// LA が起動できる状態なら Signal されるイベントを取得します。
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// </remarks>
        [MethodId(9)]
        Result GetLibraryAppletLaunchableEvent(Out<NativeHandle> pOut);

        /// <summary>
        /// スクリーンショット撮影許可状態を変更する
        /// </summary>
        /// <remarks>
        /// アプレット起動直後のデフォルトでは呼出元の状態を継承
        /// </remarks>
        [MethodId(10)]
        Result SetScreenShotPermission(int permission);

        /// <summary>
        /// 動作モード変更メッセージの通知有無の指定
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(11)]
        Result SetOperationModeChangedNotification(bool needNotify);

        /// <summary>
        /// 性能モード変更メッセージの通知有無の指定
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(12)]
        Result SetPerformanceModeChangedNotification(bool needNotify);

        /// <summary>
        /// 状態変更メッセージ通知および自動中断機能の指定
        /// </summary>
        /// <param name="focus">InFocus, OutOfFocus メッセージ通知の有無</param>
        /// <param name="background">Background メッセージ通知の有無</param>
        /// <param name="pause">バックグラウンド状態時の自動中断の有無</param>
        /// <remarks>
        /// </remarks>
        [MethodId(13)]
        Result SetFocusHandlingMode(bool focus, bool background, bool pause);

        /// <summary>
        /// 状態変更メッセージ通知および自動中断機能の指定
        /// </summary>
        /// <param name="enabled">MessageRestartFromSuspend 通知の有無</param>
        /// <remarks>
        /// </remarks>
        [MethodId(14)]
        Result SetRestartMessageEnabled(bool enabled);

        /// <summary>
        /// スクリーンショット撮影時の画像ファイルに適用するアプレット情報の設定
        /// </summary>
        [MethodId(15)]
        Result SetScreenShotAppletIdentityInfo(AppletIdentityInfo info);

        /// <summary>
        /// OutOfFocus 時にサスペンドするか否かを指定
        /// </summary>
        /// <param name="isEnabled">OutOfFocus 状態時の自動中断の有無</param>
        /// <remarks>
        /// </remarks>
        [MethodId(16)]
        Result SetOutOfFocusSuspendingEnabled(bool isEnabled);

        /// <summary>
        /// コントローラ F/W 更新期間の開始と終了の指定
        /// </summary>
        /// <param name="isInSection">F/W 更新開始時に true、終了時に false</param>
        /// <remarks>
        /// - 本 IPC は LA 専用
        /// - F/W 更新期間中は以下のボタン操作検知を LA が横取り
        /// -- HOME ボタン短押し と 長押し
        /// -- POWER ボタン短押し
        /// </remarks>
        [MethodId(17)]
        Result SetControllerFirmwareUpdateSection(bool isInSection);

        /// <summary>
        /// キャプチャボタン短押しのハンドリング開始と終了の制御
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(18)]
        Result SetRequiresCaptureButtonShortPressedMessage(bool isRequires);

        /// <summary>
        /// スクリーンショット撮影画像の回転方向を設定する
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(19)]
        Result SetAlbumImageOrientation(int orientation);

        /// <summary>
        /// USB キーボード配列を指定する
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(20)]
        Result SetDesirableKeyboardLayout(Bit32 layout);

        [MethodId(40)]
        Result CreateManagedDisplayLayer(Out<Bit64> pOutLayerId);

        [MethodId(41)]
        Result IsSystemBufferSharingEnabled();

        [MethodId(42)]
        Result GetSystemSharedLayerHandle(Out<vi.fbshare.SharedBufferHandle> pOutBufferHandle, Out<vi.fbshare.SharedLayerHandle> pOutLayerHandle);

        [MethodId(43)]
        Result GetSystemSharedBufferHandle(Out<vi.fbshare.SharedBufferHandle> pOutBufferHandle);

        [MethodId(50)]
        Result SetHandlesRequestToDisplay(bool handlesRequestToDisplay);

        [MethodId(51)]
        Result ApproveToDisplay();

        /// <summary>
        /// 無操作状態検出時の自動スリープ時間や自動低輝度化発動時間の上書き
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(60)]
        Result OverrideAutoSleepTimeAndDimmingTime(int autoSleepTimeInHandheld, int autoSleepTimeInConsole, int dimmingTimeInHandheld, int dimmingTimeInConsole);

        /// <summary>
        /// メディア再生中か否かを設定
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(61)]
        Result SetMediaPlaybackState(bool isInMediaPlayback);

        /// <summary>
        /// 自動スリープ時間や自動低輝度化発動時間の延長（アプリ用）
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(62)]
        Result SetIdleTimeDetectionExtension(uint32_t extensionType);

        /// <summary>
        /// 自動スリープ時間や自動低輝度化発動時間の取得（アプリ用）
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(63)]
        Result GetIdleTimeDetectionExtension(Out<uint32_t> pOut);

        /// <summary>
        /// 無操作状態検出機能における検知対象入力デバイスの指定
        /// </summary>
        /// <returns></returns>
        [MethodId(64)]
        Result SetInputDetectionSourceSet(Bit32 inputSources);

        /// <summary>
        /// ユーザの操作があったことを明示的に宣言する
        /// </summary>
        /// <returns></returns>
        [MethodId(65)]
        Result ReportUserIsActive();

        /// <summary>
        /// 現在のプレイ環境での照度の取得 (deprecated)
        /// </summary>
        /// <remarks>
        /// NX Addon 3.0.0 ～ NX Addon 5.2.0 で nn::pl::GetCurrentIlluminance() を呼び出しているアプリ向けの互換維持のため残している
        /// 本 API はある特定タイトルにしかリリースしておらず (5.3.0 リリース時点)、当該タイトルは 5.3.0 以降でマスターアップするため、当該タイトルの開発途中の ROM しか該当しない
        /// </remarks>
        [MethodId(66)]
        Result GetCurrentIlluminance(Out<float> pOut);

        /// <summary>
        /// 現在のプレイ環境での照度の取得 (光量過多フラグ付き)
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(71)]
        Result GetCurrentIlluminanceEx(Out<float> pOut, Out<bool> pOutOverflowAlert);

        /// <summary>
        /// 照度が取得可能かの取得
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(67)]
        Result IsIlluminanceAvailable(Out<bool> pOut);

        /// <summary>
        /// 自動スリープを無効化するか否かを設定
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(68)]
        Result SetAutoSleepDisabled(bool isDisabled);

        /// <summary>
        /// 自動スリープを無効化するか否かを取得
        /// </summary>
        /// <remarks>
        /// </remarks>
        [MethodId(69)]
        Result IsAutoSleepDisabled(Out<bool> pOut);

        /// <summary>
        /// マルチメディア関連のエラーレポートの作成
        /// </summary>
        [MethodId(70)]
        Result ReportMultimediaError(Bit32 resultValue,  InBuffer multimediaTelemetry);

        /// <summary>
        /// 無線の優先モード種別の設定
        /// </summary>
        /// <param name="mode">無線の優先モード種別</param>
        /// <remarks>
        /// </remarks>
        [MethodId(80)]
        Result SetWirelessPriorityMode(int mode);
    }
}
