﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.am.service
{
    [CppRefPath(Location.FunctionsSfdlPath)]
    public interface IHomeMenuFunctions : IServiceObject
    {
        /// <summary>
        /// メニューが FG になれるように要求を出す
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// メニューが BG の時に、自身が FG になれるように
        /// アプレットマネージャに要求を出します。
        ///
        /// アプレットマネージャは、現在 FG のアプレットに
        /// Message_ChangeIntoBackground を通知します。
        ///
        /// 対象アプレットが ReleaseForegroundRights() で返答した場合は、
        /// SA に対して Message_ChangeIntoForeground を通知します。
        //
        /// 対象アプレットが RejectToChangeIntoBackground() で返答した場合は、
        /// SA に対して Message_RejectedChangedIntoBackground を通知します。
        /// </remarks>
        [MethodId(10)]
        Result RequestToGetForeground();

        /// <summary>
        /// 強制的に FG 状態に遷移し、スクリーンをロックします。
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// </remarks>
        [MethodId(11)]
        Result LockForeground();

        /// <summary>
        /// スクリーンロックを解除し、強制 FG 状態を解除します。
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// </remarks>
        [MethodId(12)]
        Result UnlockForeground();

        [MethodId(20)]
        Result PopFromGeneralChannel(Out<IStorage> pOut);

        [MethodId(21)]
        Result GetPopFromGeneralChannelEvent(Out<NativeHandle> pOut);

        [MethodId(30)]
        Result GetHomeButtonWriterLockAccessor(Out<ILockAccessor> pOut);

        [MethodId(31)]
        Result GetWriterLockAccessorEx(Out<ILockAccessor> pOut, int index);

        #region デバッグ用

        [MethodId(100)]
        Result PopRequestLaunchApplicationForDebug(Out<ncm.ApplicationId> pApplicationId, Out<int> pOutUidCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<account.Uid> outUids);

        #endregion
    }
}
