﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.am.service
{
    [ExternalStruct(4, 4)]
    public struct EmulatedButtonEvent
    {
    }

    [CppRefPath(Location.FunctionsSfdlPath)]
    public interface IDebugFunctions : IServiceObject
    {
        /// <summary>
        /// SA メニューにメッセージを通知する（デバッグ用）
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// TODO: デバッグ用 API
        ///
        /// デバッグ時やエージング目的のためのメソッドで、
        /// 各アプレットから SA メニューに対して、message を通知します。
        /// 主に HOME ボタン押下や POWER ボタン押下といった、
        /// メッセージ通知以外の副作用のないもののためだけに使用できます。
        /// </remarks>
        [MethodId(0)]
        Result NotifyMessageToHomeMenuForDebug(AppletMessage message);

        /// <summary>
        /// 起動済みアプリケーションの IApplicationAccessor を取得する
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// </remarks>
        [MethodId(1)]
        Result OpenMainApplication(Out<IApplicationAccessor> pOut);

        [MethodId(10)]
        Result EmulateButtonEvent(EmulatedButtonEvent e);

        [MethodId(20)]
        Result InvalidateTransitionLayer();
    }

    [CppRefPath(Location.FunctionsSfdlPath)]
    public interface ISystemAppletControllerForDebug : IServiceObject
    {
        [MethodId(1)]
        Result RequestLaunchApplicationForDebug(ncm.ApplicationId applicationId, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<account.Uid> uids);
    }
}
