﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/window/am_SpsmEventWindowController.h>

#include <nn/am/service/window/am_WindowSystem.h>

namespace nn { namespace am { namespace service { namespace window {

void SpsmEventWindowController::UpdateImmediately(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    NN_UNUSED(oldStatus);
    static_cast<Status&>(p->RefEventStatus()) = newStatus;
}

void SpsmEventWindowController::HandleEvent(Window* p, const EventStatus& eventStatus, const EventType& e) NN_NOEXCEPT
{
    if (eventStatus.handlesSleepRequiredByHighTemperature && e.onSleepRequiredByHighTemperature)
    {
        p->GetTransiter()->OnSleepRequiredByHighTemperature();
    }
    if (eventStatus.handlesSleepRequiredByLowBattery && e.onSleepRequiredByLowBattery)
    {
        p->GetTransiter()->OnSleepRequiredByLowBattery();
    }
    if (eventStatus.handlesAutoPowerDown && e.onAutoPowerDown)
    {
        p->GetTransiter()->OnAutoPowerDown();
    }
}

}}}}
