﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/window/am_HomeButtonWindowController.h>

#include <nn/am/service/window/am_WindowSystem.h>
#include <nn/spsm/spsm_Api.h>
#include <nn/am/service/am_StuckChecker.h>

namespace nn { namespace am { namespace service { namespace window {

void HomeButtonWindowController::UpdateNegative(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    NN_UNUSED(p);
    NN_UNUSED(oldStatus);
    if (newStatus.longPressingTimeToSet)
    {
        NN_AM_SERVICE_LOG(seq, "spsm::ChangeHomeButtonLongPressingTime(%dms)\n", static_cast<int>(newStatus.longPressingTimeToSet->GetMilliSeconds()));
        NN_AM_SERVICE_STUCK_CHECKED(spsm, 60, spsm::ChangeHomeButtonLongPressingTime(*newStatus.longPressingTimeToSet));
    }
}

void HomeButtonWindowController::UpdateImmediately(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    NN_UNUSED(oldStatus);
    static_cast<Status&>(p->RefEventStatus()) = newStatus;
}

void HomeButtonWindowController::HandleEvent(Window* p, const EventStatus& eventStatus, const EventType& e) NN_NOEXCEPT
{
    if (eventStatus.handlesShort && e.onPressedShort)
    {
        p->GetTransiter()->OnHomeButtonShortPressed();
    }
    if (eventStatus.handlesLong && e.onPressedLong)
    {
        p->GetTransiter()->OnHomeButtonLongPressed();
    }
}

}}}}
