﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/window/am_HidWindowController.h>

#include <nn/am/service/window/am_WindowSystem.h>

namespace nn { namespace am { namespace service { namespace window {

void HidWindowController::UpdateNegative(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    // Npad および hid 入力の制御
    if (oldStatus.needHidInput && !newStatus.needHidInput)
    {
        p->GetTransiter()->NotifyHidInputRequirement(false);
    }

    // IrSensor の制御
    if (oldStatus.needIrSensorInput && !newStatus.needIrSensorInput)
    {
        p->GetTransiter()->NotifyIrSensorInputRequirement(false);
    }

    // 振動子の制御
    if (oldStatus.vibrationOwner && !newStatus.vibrationOwner)
    {
        p->GetTransiter()->NotifyVibrationOwner(false);
    }

    // ６軸センサーの制御
    if (oldStatus.needSixAxisSensorInput && !newStatus.needSixAxisSensorInput)
    {
        p->GetTransiter()->NotifySixAxisSensorInputRequirement(false);
    }
}

void HidWindowController::UpdatePositive(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    // Npad および hid 入力の制御
    if (!oldStatus.npadPolicyOwner && newStatus.npadPolicyOwner)
    {
        p->GetTransiter()->NotifyHidNpadPolicyOwner();
    }
    if (!oldStatus.needHidInput && newStatus.needHidInput)
    {
        p->GetTransiter()->NotifyHidInputRequirement(true);
    }

    // IrSensor の制御
    if (!oldStatus.irSensorPolicyOwner && newStatus.irSensorPolicyOwner)
    {
        p->GetTransiter()->NotifyIrSensorPolicyOwner();
    }
    if (!oldStatus.needIrSensorInput && newStatus.needIrSensorInput)
    {
        p->GetTransiter()->NotifyIrSensorInputRequirement(true);
    }

    // HidBus の制御
    if (!oldStatus.hidbusPolicyOwner && newStatus.hidbusPolicyOwner)
    {
        p->GetTransiter()->NotifyHidBusPolicyOwner();
    }

    // 振動子の制御
    if (!oldStatus.vibrationOwner && newStatus.vibrationOwner)
    {
        p->GetTransiter()->NotifyVibrationOwner(true);
    }

    // ６軸センサーの制御
    if (!oldStatus.needSixAxisSensorInput && newStatus.needSixAxisSensorInput)
    {
        p->GetTransiter()->NotifySixAxisSensorInputRequirement(true);
    }

    // BLE の制御
    if (!oldStatus.bleConnectionOwner && newStatus.bleConnectionOwner)
    {
        p->GetTransiter()->NotifyBleConnectionOwner();
    }
}

}}}}
