﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/window/am_ForegroundWindowController.h>

#include <nn/am/service/window/am_WindowSystem.h>

namespace nn { namespace am { namespace service { namespace window {

void ForegroundWindowController::UpdateNegative(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    if (oldStatus.canRun && !newStatus.canRun)
    {
        p->GetTransiter()->SetCanRun(newStatus.canRun);
    }
    if (oldStatus.focusState < newStatus.focusState)
    {
        p->GetTransiter()->SetForeground(newStatus.focusState, newStatus.canUseApplicationCoreAsRequested);
    }
    else if (oldStatus.focusState == newStatus.focusState)
    {
        if (!newStatus.canUseApplicationCoreAsRequested && oldStatus.canUseApplicationCoreAsRequested)
        {
            p->GetTransiter()->SetForeground(newStatus.focusState, newStatus.canUseApplicationCoreAsRequested);
        }
    }
    if (newStatus.pGpuResourceControlInfo)
    {
        SetGpuResourceControl(*newStatus.pGpuResourceControlInfo);
    }
    if (newStatus.pWirelessPriorityMode)
    {
        p->GetTransiter()->OnWirelessPriorityModeChanged(*newStatus.pWirelessPriorityMode);
    }
}

void ForegroundWindowController::UpdatePositive(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    if (oldStatus.focusState > newStatus.focusState)
    {
        p->GetTransiter()->SetForeground(newStatus.focusState, newStatus.canUseApplicationCoreAsRequested);
    }
    else if (oldStatus.focusState == newStatus.focusState)
    {
        if (newStatus.canUseApplicationCoreAsRequested && !oldStatus.canUseApplicationCoreAsRequested)
        {
            p->GetTransiter()->SetForeground(newStatus.focusState, newStatus.canUseApplicationCoreAsRequested);
        }
    }
    if (!oldStatus.canRun && newStatus.canRun)
    {
        p->GetTransiter()->SetCanRun(newStatus.canRun);
    }
}


void ForegroundWindowController::HandleEvent(Window* p, const EventStatus&, const EventType& e) NN_NOEXCEPT
{
    if (e.onFatal)
    {
        p->GetTransiter()->OnFatal();
    }
    if (e.pExceptionProcessId)
    {
        p->GetTransiter()->OnProcessException(*e.pExceptionProcessId);
    }
}

}}}}
