﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/display/am_CaptureBufferManager.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace am { namespace service { namespace display {

bool CaptureBufferManager::IsBufferScreenshotEnabled(CaptureBufferIndex index) NN_NOEXCEPT
{
    auto& captureBuffer = m_CaptureBuffer[index];
    return captureBuffer.IsCaptureImageValid();
}

bool CaptureBufferManager::IsBufferCopyrightRequested(CaptureBufferIndex index) NN_NOEXCEPT
{
    auto& captureBuffer = m_CaptureBuffer[index];
    return captureBuffer.IsCaptureImageCopyrighted();
}

void CaptureBufferManager::SetCaptureBufferState(CaptureBufferIndex index, bool isCaptureEnabled, bool isCopyrighted) NN_NOEXCEPT
{
    auto& captureBuffer = m_CaptureBuffer[index];
    captureBuffer.SetCaptureImageValidity(isCaptureEnabled);
    captureBuffer.SetCaptureImageCopyrighted(isCopyrighted);
}

}}}}
