﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/am/service/am_AppletSystem.h>

namespace nn { namespace am { namespace service {

//-----------------------------------------------------------------------------
//  SD カードイベント監視用クラス
//  TORIAEZU:
//      単一スレッドでの利用を前提としているため、
//      m_State 変数の排他などは行なわない。
//
class SdCardEvent
{
public:
    explicit SdCardEvent(AppletSystem* pAppletSystem) NN_NOEXCEPT;
    ~SdCardEvent() NN_NOEXCEPT;

    void LinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        os::LinkMultiWaitHolder(p, &m_SdCardEventHolder);
    }
    void UnlinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        NN_UNUSED(p);
        os::UnlinkMultiWaitHolder(&m_SdCardEventHolder);
    }
    bool HandleEventIfHolderOwner(os::MultiWaitHolderType* holder)
    {
        if (holder == &m_SdCardEventHolder)
        {
            SdCardEventHandler();
            return true;
        }
        return false;
    }

private:
    void SdCardEventHandler() NN_NOEXCEPT;

    void NotifySdCardRemoved() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(event, "sd card removed\n");
        m_pAppletSystem->GetWindowManager()->NotifySdCardRemoved();
    }

private:
    AppletSystem*               m_pAppletSystem;

    os::SystemEvent             m_SdCardRemovedEvent;

    os::MultiWaitHolderType     m_SdCardEventHolder;
};

//-----------------------------------------------------------------------------

}}} // namespace nn::am::service
