﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>

#include "am_SdCardEvent.h"

namespace nn { namespace am { namespace service {

//-----------------------------------------------------------------------------
//  コンストラクタ
//
SdCardEvent::SdCardEvent(AppletSystem* pAppletSystem) NN_NOEXCEPT
      : m_pAppletSystem( pAppletSystem )
{
    ns::GetSdCardRemovedEvent( &m_SdCardRemovedEvent );
    os::InitializeMultiWaitHolder( &m_SdCardEventHolder, m_SdCardRemovedEvent.GetBase() );
    m_SdCardEventHolder.userData = reinterpret_cast<uintptr_t>(this);
}


//-----------------------------------------------------------------------------
//  デストラクタ
//
SdCardEvent::~SdCardEvent() NN_NOEXCEPT
{
    os::FinalizeMultiWaitHolder( &m_SdCardEventHolder );
}


//-----------------------------------------------------------------------------
//  SD カードイベントハンドラ関数（多重待ち解除時に呼ばれる）
//
void SdCardEvent::SdCardEventHandler() NN_NOEXCEPT
{
    if ( !m_SdCardRemovedEvent.TryWait() )
    {
        return;
    }
    m_SdCardRemovedEvent.Clear();
    NotifySdCardRemoved();
}


//-----------------------------------------------------------------------------

}}} // namespace nn::am::service
