﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/am_PlayDataManager.h>
#include <nn/pdm/pdm_NotifyEventApi.h>
#include <nn/pm/pm_BootModeApi.h>
#include <nn/util/util_ScopeExit.h>

namespace nn { namespace am { namespace service {
    namespace {
        pm::BootMode g_BootMode;
        bool g_IsInitialized{ false };

        bool IsMaintenanceMode() NN_NOEXCEPT
        {
            return g_BootMode == pm::BootMode_Maintenance;
        }
    }

    void InitializePlayDataManager() NN_NOEXCEPT
    {
        NN_SDK_ASSERT(!g_IsInitialized);
        NN_UTIL_SCOPE_EXIT{ g_IsInitialized = true; };

        g_BootMode = pm::GetBootMode();

        if (IsMaintenanceMode())
        {
            return;
        }

        pdm::InitializeForNotification();
    }

    void NotifyAppletEvent(pdm::AppletEventType eventType, nn::ncm::ProgramId programId, uint32_t version, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(g_IsInitialized);

        if (IsMaintenanceMode())
        {
            return;
        }

        pdm::NotifyAppletEvent(eventType, programId, version, appletId, storageId, logPolicy);
    }

    void NotifyLibraryAppletEvent(pdm::AppletEventType eventType, nn::ncm::ProgramId programId, applet::LibraryAppletMode libraryAppletMode, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(g_IsInitialized);

        if (IsMaintenanceMode())
        {
            return;
        }

        pdm::NotifyLibraryAppletEvent(eventType, programId, libraryAppletMode, appletId, storageId, logPolicy);
    }

    void NotifyOperationModeChangeEvent(oe::OperationMode operationMode) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(g_IsInitialized);

        if (IsMaintenanceMode())
        {
            return;
        }

        pdm::NotifyOperationModeChangeEvent(operationMode);
    }

    void NotifyPowerStateChangeEvent(pdm::PowerStateChangeEventType eventType) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(g_IsInitialized);

        if (IsMaintenanceMode())
        {
            return;
        }

        pdm::NotifyPowerStateChangeEvent(eventType);
    }
}}}
