﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <memory>
#include <utility>
#include <nn/am/service/am_Functions.sfdl.h>

namespace nn { namespace am { namespace service {

    bool IsGrcAvailable() NN_NOEXCEPT;

    class GrcOccupier
    {
    private:
        bool m_HasOccupation = false;
    public:
        explicit GrcOccupier(bool occupy = false) NN_NOEXCEPT
        {
            if (occupy)
            {
                Occupy();
            }
        }
        GrcOccupier(GrcOccupier&& x) NN_NOEXCEPT
            : m_HasOccupation(std::exchange(x.m_HasOccupation, false))
        {
        }
        GrcOccupier& operator=(GrcOccupier&& x) NN_NOEXCEPT
        {
            GrcOccupier tmp(std::move(x));
            this->swap(tmp);
            return *this;
        }
        ~GrcOccupier() NN_NOEXCEPT
        {
            if (m_HasOccupation)
            {
                Unoccupy();
            }
        }
        void swap(GrcOccupier& x) NN_NOEXCEPT
        {
            std::swap(this->m_HasOccupation, x.m_HasOccupation);
        }
        bool HasOccupation() const NN_NOEXCEPT
        {
            return m_HasOccupation;
        }
        void Occupy() NN_NOEXCEPT;
        void Unoccupy() NN_NOEXCEPT;
    };

    class MovieMakerMixin
    {
    public:
        virtual ~MovieMakerMixin() NN_NOEXCEPT = default;
    };

    Result CreateMovieMaker(sf::Out<sf::SharedPointer<IMovieMaker>> pOut, applet::AppletResourceUserId aruid, ncm::ApplicationId applicationId, sf::NativeHandle transferMemoryHandle, size_t transferMemorySize, std::shared_ptr<MovieMakerMixin> pMovieMakerMixin = nullptr) NN_NOEXCEPT;
    Result CreateGameMovieTrimmer(sf::Out<sf::SharedPointer<grcsrv::IGameMovieTrimmer>> pOut, GrcOccupier* pGrcOccupier, sf::NativeHandle transferMemoryHandle, uint64_t transferMemorySize) NN_NOEXCEPT;

}}}
