﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Compiler.h>

#include <nn/nn_Common.h>
#include <nn/util/util_BitUtil.h>

#ifdef NN_BUILD_CONFIG_COMPILER_CLANG
    #define NN_AM_SERVICE_CONSTEXPR_FUNCTION constexpr
#else
    #define NN_AM_SERVICE_CONSTEXPR_FUNCTION inline
#endif

namespace nn { namespace am { namespace service {

template <typename T>
inline int popcount(T x) NN_NOEXCEPT
{
    return util::popcount(x);
}

template <typename T>
inline int cntl0(T x) NN_NOEXCEPT
{
    return util::cntl0(x);
}

template <typename T>
inline int cntt0(T x) NN_NOEXCEPT
{
    return util::cntt0(x);
}

#ifdef NN_BUILD_CONFIG_COMPILER_CLANG

// TODO: そのうち nn::util にうつしたい

NN_AM_SERVICE_CONSTEXPR_FUNCTION int popcount(unsigned int x) NN_NOEXCEPT
{
    return __builtin_popcount(x);
}

NN_AM_SERVICE_CONSTEXPR_FUNCTION int popcount(unsigned long x) NN_NOEXCEPT
{
    return __builtin_popcountl(x);
}

NN_AM_SERVICE_CONSTEXPR_FUNCTION int popcount(unsigned long long x) NN_NOEXCEPT
{
    return __builtin_popcountll(x);
}

NN_AM_SERVICE_CONSTEXPR_FUNCTION int cntl0(unsigned int x) NN_NOEXCEPT
{
    return x == 0 ? NN_BITSIZEOF(decltype(x)) : __builtin_clz(x);
}

NN_AM_SERVICE_CONSTEXPR_FUNCTION int cntl0(unsigned long x) NN_NOEXCEPT
{
    return x == 0 ? NN_BITSIZEOF(decltype(x)) : __builtin_clzl(x);
}

NN_AM_SERVICE_CONSTEXPR_FUNCTION int cntl0(unsigned long long x) NN_NOEXCEPT
{
    return x == 0 ? NN_BITSIZEOF(decltype(x)) : __builtin_clzll(x);
}

NN_AM_SERVICE_CONSTEXPR_FUNCTION int cntt0(unsigned int x) NN_NOEXCEPT
{
    return x == 0 ? NN_BITSIZEOF(decltype(x)) : __builtin_ctz(x);
}

NN_AM_SERVICE_CONSTEXPR_FUNCTION int cntt0(unsigned long x) NN_NOEXCEPT
{
    return x == 0 ? NN_BITSIZEOF(decltype(x)) : __builtin_ctzl(x);
}

NN_AM_SERVICE_CONSTEXPR_FUNCTION int cntt0(unsigned long long x) NN_NOEXCEPT
{
    return x == 0 ? NN_BITSIZEOF(decltype(x)) : __builtin_ctzll(x);
}

#endif

}}}
