﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/apm/apm_Api.h>
#include <nn/apm/apm_SystemApi.h>
#include <nn/am/service/am_AppletSystem.h>

namespace nn { namespace am { namespace service {

//-----------------------------------------------------------------------------
//  Apm 監視用クラス
//  TORIAEZU:
//      単一スレッドでの利用を前提としているため、
//      m_State 変数の排他などは行なわない。
//
class ApmEvent
{
public:
    explicit ApmEvent(AppletSystem* pAppletSystem) NN_NOEXCEPT;
    ~ApmEvent() NN_NOEXCEPT;

    void LinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        os::LinkMultiWaitHolder(p, &m_ApmEventHolder);
    }
    void UnlinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        NN_UNUSED(p);
        os::UnlinkMultiWaitHolder(&m_ApmEventHolder);
    }
    bool HandleEventIfHolderOwner(os::MultiWaitHolderType* holder)
    {
        if (holder == &m_ApmEventHolder)
        {
            ApmEventHandler();
            return true;
        }
        return false;
    }

private:
    void ApmEventHandler() NN_NOEXCEPT;

    void NotifyPerformanceModeChanged() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(event, "performance mode changed\n");
        m_pAppletSystem->GetWindowManager()->NotifyPerformanceModeChanged();
    }

private:
    AppletSystem*               m_pAppletSystem;

    os::SystemEventType         m_ApmEvent;

    os::MultiWaitHolderType     m_ApmEventHolder;
};

//-----------------------------------------------------------------------------

}}} // namespace nn::am::service

