﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn
{
    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/nn_TimeSpan.h>")]
    public struct TimeSpanType
    {
    }
}

namespace nn.ahid
{
    [CppRefPath(@"<nn/ahid/sfdl/IServerSession.sfdl.h>")]
    public interface IServerSession : IServiceObject
    {
        [MethodId(0)]
        Result AcquireDevice(uint32_t deviceHandle);

        [MethodId(1)]
        Result ReleaseDevice(uint32_t deviceHandle);

        [MethodId(2)]
        Result GetCtrlSession(uint32_t deviceHandle, Out<ICtrlSession> outCtrlSession);

        [MethodId(3)]
        Result GetReadSession(uint32_t deviceHandle, Out<IReadSession> outReadSession);
    }

    [CppRefPath(@"<nn/ahid/sfdl/ICtrlSession.sfdl.h>")]
    public interface ICtrlSession : IServiceObject
    {
        [MethodId(0)]
        Result GetString(uint8_t stringIndex, nn.sf.OutBuffer outBuffer);

        [MethodId(1)]
        Result GetCodeBook(nn.sf.OutBuffer outBuffer);

        [MethodId(2)]
        Result GetReport(uint8_t reportType, uint8_t reportId, nn.sf.OutBuffer outBuffer);

        [MethodId(3)]
        Result SetReport(uint8_t reportType, uint8_t reportId, nn.sf.InBuffer inBuffer);

        [MethodId(4)]
        Result GetIdle(nn.sf.OutBuffer outBuffer, uint8_t reportId);

        [MethodId(5)]
        Result SetIdle(uint8_t idle, uint8_t reportId);

        [MethodId(6)]
        Result GetProtocol(nn.sf.OutBuffer outBuffer);

        [MethodId(7)]
        Result SetProtocol(uint8_t protocol);

        [MethodId(8)]
        Result GetDescriptor(nn.sf.OutBuffer outBuffer, uint8_t bmRequestType, uint16_t wValue, uint16_t wIndex);

        [MethodId(9)]
        Result SetDescriptor(nn.sf.InBuffer inBuffer, uint8_t bmRequestType, uint16_t wValue, uint16_t wIndex);

        [MethodId(10)]
        Result GetStateChangeEvent(Out<NativeHandle> eventHandler);

        [MethodId(11)]
        Result SignalStateChangeEvent();

        [MethodId(12)]
        Result Write(nn.sf.InBuffer inBuffer, nn.sf.Out<uint32_t> pBytesWritten, nn.TimeSpanType timeout);
    }

    [CppRefPath(@"<nn/ahid/sfdl/IReadSession.sfdl.h>")]
    public interface IReadSession : IServiceObject
    {
        [MethodId(0)]
        Result Read(nn.sf.OutBuffer outBuffer, nn.sf.Out<uint32_t> pBytesRead, nn.TimeSpanType timeout);
    }
}
