﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace ahid {
namespace hdr {

class HdrServer;
class HdrSession
{

    NN_DISALLOW_COPY(HdrSession);
    NN_DISALLOW_MOVE(HdrSession);

public:

    NN_IMPLICIT HdrSession(HdrServer *pHdrServer, bool isDfcSession) NN_NOEXCEPT;
    ~HdrSession() NN_NOEXCEPT;

    Result GetDeviceEntries(nn::sf::Out<std::uint32_t> pEntries) NN_NOEXCEPT;
    Result GetDeviceList(nn::sf::Out<std::uint32_t> pOutEntries, uint32_t inEntries, nn::sf::OutBuffer outDeviceHandles, nn::sf::InBuffer inAttachFilter) NN_NOEXCEPT;
    Result GetDeviceParameters(DeviceHandle handle, nn::sf::OutBuffer outDeviceParameters) NN_NOEXCEPT;
    Result AttachDevice(nn::sf::InBuffer inDeviceParameters, nn::sf::Out<DeviceHandle> outHandle) NN_NOEXCEPT;
    Result DetachDevice(DeviceHandle handle) NN_NOEXCEPT;
    Result SetDeviceFilterForHipc(nn::sf::InBuffer inDeviceFilter, uint32_t inEntries) NN_NOEXCEPT;

private:

    bool DeviceIsFilteredForHipc(int deviceEntry) NN_NOEXCEPT;

    HdrServer*  m_pHdrServer;
    bool        m_IsDfcSession;
};

}   // namespace hdr
}   // namespace ahid
}   // namespace nn
