﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ahid/hdr/sfdl/ISession.sfdl.h>

namespace nn {
namespace ahid {
namespace hdr {

enum
{
    HDR_SERVER_STACK_SIZE   = 16 * 1024,
    HDR_SERVER_MAX_SESSIONS = 16,
};

class HdrServer : public nn::sf::HipcSimpleAllInOneServerManager<HDR_SERVER_MAX_SESSIONS, 1>
{

    NN_DISALLOW_COPY(HdrServer);
    NN_DISALLOW_MOVE(HdrServer);

public:

    HdrServer() NN_NOEXCEPT {};
    ~HdrServer() NN_NOEXCEPT {};

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;
    nn::sf::SharedPointer<nn::ahid::hdr::ISession> GetDfcSession() NN_NOEXCEPT;

    HdrHandle   m_HdrHandle;
    HdrDevice   m_HdrDevice;
    HdrMutex    m_HdrMutex;

    DeviceFilter   *m_pDeviceFilter;
    uint32_t        m_DeviceFilterEntries;

private:

    // Heap
    std::aligned_storage<16 * 1024>::type   m_SfHeapBuffer;
    nn::sf::ExpHeapAllocator                m_SfAllocator;
    nn::lmem::HeapHandle                    m_HeapHandle;

    // Thread
    NN_ALIGNAS(4096) uint8_t                m_ThreadStack[HDR_SERVER_STACK_SIZE];
    nn::os::ThreadType                      m_Thread;

    nn::sf::SharedPointer<nn::ahid::hdr::ISession> CreateSession(bool isDfcSession) NN_NOEXCEPT;
    virtual nn::Result OnNeedsToAccept(int portIndex, PortObjectImpl* pPort) NN_NOEXCEPT;
    static void SessionThread(void *arg) NN_NOEXCEPT;
};

}   // namespace hdr
}   // namespace ahid
}   // namespace nn
